/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acmpca.AcmPcaClient;
import software.amazon.awssdk.services.acmpca.AcmPcaClientBuilder;
import software.amazon.awssdk.services.acmpca.AcmPcaServiceClientConfiguration;
import software.amazon.awssdk.services.acmpca.DefaultAcmPcaBaseClientBuilder;
import software.amazon.awssdk.services.acmpca.DefaultAcmPcaClient;
import software.amazon.awssdk.services.acmpca.endpoints.AcmPcaEndpointProvider;

@SdkInternalApi
final class DefaultAcmPcaClientBuilder
extends DefaultAcmPcaBaseClientBuilder<AcmPcaClientBuilder, AcmPcaClient>
implements AcmPcaClientBuilder {
    DefaultAcmPcaClientBuilder() {
    }

    @Override
    public DefaultAcmPcaClientBuilder endpointProvider(AcmPcaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmPcaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAcmPcaClientBuilder.validateClientOptions(clientConfiguration);
        AcmPcaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAcmPcaClient client = new DefaultAcmPcaClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AcmPcaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AcmPcaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

