/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acmpca.AcmPcaClient;
import software.amazon.awssdk.services.acmpca.AcmPcaClientBuilder;
import software.amazon.awssdk.services.acmpca.AcmPcaServiceClientConfiguration;
import software.amazon.awssdk.services.acmpca.DefaultAcmPcaBaseClientBuilder;
import software.amazon.awssdk.services.acmpca.DefaultAcmPcaClient;
import software.amazon.awssdk.services.acmpca.endpoints.AcmPcaEndpointProvider;

@SdkInternalApi
final class DefaultAcmPcaClientBuilder
extends DefaultAcmPcaBaseClientBuilder<AcmPcaClientBuilder, AcmPcaClient>
implements AcmPcaClientBuilder {
    DefaultAcmPcaClientBuilder() {
    }

    @Override
    public DefaultAcmPcaClientBuilder endpointProvider(AcmPcaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmPcaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAcmPcaClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AcmPcaServiceClientConfiguration serviceClientConfiguration = AcmPcaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAcmPcaClient(serviceClientConfiguration, clientConfiguration);
    }
}

