/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyUsage> {
    private static final SdkField<Boolean> DIGITAL_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DigitalSignature").getter(KeyUsage.getter(KeyUsage::digitalSignature)).setter(KeyUsage.setter(Builder::digitalSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigitalSignature").build()}).build();
    private static final SdkField<Boolean> NON_REPUDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NonRepudiation").getter(KeyUsage.getter(KeyUsage::nonRepudiation)).setter(KeyUsage.setter(Builder::nonRepudiation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRepudiation").build()}).build();
    private static final SdkField<Boolean> KEY_ENCIPHERMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyEncipherment").getter(KeyUsage.getter(KeyUsage::keyEncipherment)).setter(KeyUsage.setter(Builder::keyEncipherment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyEncipherment").build()}).build();
    private static final SdkField<Boolean> DATA_ENCIPHERMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataEncipherment").getter(KeyUsage.getter(KeyUsage::dataEncipherment)).setter(KeyUsage.setter(Builder::dataEncipherment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncipherment").build()}).build();
    private static final SdkField<Boolean> KEY_AGREEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyAgreement").getter(KeyUsage.getter(KeyUsage::keyAgreement)).setter(KeyUsage.setter(Builder::keyAgreement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreement").build()}).build();
    private static final SdkField<Boolean> KEY_CERT_SIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyCertSign").getter(KeyUsage.getter(KeyUsage::keyCertSign)).setter(KeyUsage.setter(Builder::keyCertSign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCertSign").build()}).build();
    private static final SdkField<Boolean> CRL_SIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CRLSign").getter(KeyUsage.getter(KeyUsage::crlSign)).setter(KeyUsage.setter(Builder::crlSign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CRLSign").build()}).build();
    private static final SdkField<Boolean> ENCIPHER_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EncipherOnly").getter(KeyUsage.getter(KeyUsage::encipherOnly)).setter(KeyUsage.setter(Builder::encipherOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncipherOnly").build()}).build();
    private static final SdkField<Boolean> DECIPHER_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DecipherOnly").getter(KeyUsage.getter(KeyUsage::decipherOnly)).setter(KeyUsage.setter(Builder::decipherOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecipherOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIGITAL_SIGNATURE_FIELD, NON_REPUDIATION_FIELD, KEY_ENCIPHERMENT_FIELD, DATA_ENCIPHERMENT_FIELD, KEY_AGREEMENT_FIELD, KEY_CERT_SIGN_FIELD, CRL_SIGN_FIELD, ENCIPHER_ONLY_FIELD, DECIPHER_ONLY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean digitalSignature;
    private final Boolean nonRepudiation;
    private final Boolean keyEncipherment;
    private final Boolean dataEncipherment;
    private final Boolean keyAgreement;
    private final Boolean keyCertSign;
    private final Boolean crlSign;
    private final Boolean encipherOnly;
    private final Boolean decipherOnly;

    private KeyUsage(BuilderImpl builder) {
        this.digitalSignature = builder.digitalSignature;
        this.nonRepudiation = builder.nonRepudiation;
        this.keyEncipherment = builder.keyEncipherment;
        this.dataEncipherment = builder.dataEncipherment;
        this.keyAgreement = builder.keyAgreement;
        this.keyCertSign = builder.keyCertSign;
        this.crlSign = builder.crlSign;
        this.encipherOnly = builder.encipherOnly;
        this.decipherOnly = builder.decipherOnly;
    }

    public final Boolean digitalSignature() {
        return this.digitalSignature;
    }

    public final Boolean nonRepudiation() {
        return this.nonRepudiation;
    }

    public final Boolean keyEncipherment() {
        return this.keyEncipherment;
    }

    public final Boolean dataEncipherment() {
        return this.dataEncipherment;
    }

    public final Boolean keyAgreement() {
        return this.keyAgreement;
    }

    public final Boolean keyCertSign() {
        return this.keyCertSign;
    }

    public final Boolean crlSign() {
        return this.crlSign;
    }

    public final Boolean encipherOnly() {
        return this.encipherOnly;
    }

    public final Boolean decipherOnly() {
        return this.decipherOnly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.digitalSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonRepudiation());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCertSign());
        hashCode = 31 * hashCode + Objects.hashCode(this.crlSign());
        hashCode = 31 * hashCode + Objects.hashCode(this.encipherOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.decipherOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsage)) {
            return false;
        }
        KeyUsage other = (KeyUsage)obj;
        return Objects.equals(this.digitalSignature(), other.digitalSignature()) && Objects.equals(this.nonRepudiation(), other.nonRepudiation()) && Objects.equals(this.keyEncipherment(), other.keyEncipherment()) && Objects.equals(this.dataEncipherment(), other.dataEncipherment()) && Objects.equals(this.keyAgreement(), other.keyAgreement()) && Objects.equals(this.keyCertSign(), other.keyCertSign()) && Objects.equals(this.crlSign(), other.crlSign()) && Objects.equals(this.encipherOnly(), other.encipherOnly()) && Objects.equals(this.decipherOnly(), other.decipherOnly());
    }

    public final String toString() {
        return ToString.builder((String)"KeyUsage").add("DigitalSignature", (Object)this.digitalSignature()).add("NonRepudiation", (Object)this.nonRepudiation()).add("KeyEncipherment", (Object)this.keyEncipherment()).add("DataEncipherment", (Object)this.dataEncipherment()).add("KeyAgreement", (Object)this.keyAgreement()).add("KeyCertSign", (Object)this.keyCertSign()).add("CRLSign", (Object)this.crlSign()).add("EncipherOnly", (Object)this.encipherOnly()).add("DecipherOnly", (Object)this.decipherOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DigitalSignature": {
                return Optional.ofNullable(clazz.cast(this.digitalSignature()));
            }
            case "NonRepudiation": {
                return Optional.ofNullable(clazz.cast(this.nonRepudiation()));
            }
            case "KeyEncipherment": {
                return Optional.ofNullable(clazz.cast(this.keyEncipherment()));
            }
            case "DataEncipherment": {
                return Optional.ofNullable(clazz.cast(this.dataEncipherment()));
            }
            case "KeyAgreement": {
                return Optional.ofNullable(clazz.cast(this.keyAgreement()));
            }
            case "KeyCertSign": {
                return Optional.ofNullable(clazz.cast(this.keyCertSign()));
            }
            case "CRLSign": {
                return Optional.ofNullable(clazz.cast(this.crlSign()));
            }
            case "EncipherOnly": {
                return Optional.ofNullable(clazz.cast(this.encipherOnly()));
            }
            case "DecipherOnly": {
                return Optional.ofNullable(clazz.cast(this.decipherOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyUsage, T> g) {
        return obj -> g.apply((KeyUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean digitalSignature;
        private Boolean nonRepudiation;
        private Boolean keyEncipherment;
        private Boolean dataEncipherment;
        private Boolean keyAgreement;
        private Boolean keyCertSign;
        private Boolean crlSign;
        private Boolean encipherOnly;
        private Boolean decipherOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsage model) {
            this.digitalSignature(model.digitalSignature);
            this.nonRepudiation(model.nonRepudiation);
            this.keyEncipherment(model.keyEncipherment);
            this.dataEncipherment(model.dataEncipherment);
            this.keyAgreement(model.keyAgreement);
            this.keyCertSign(model.keyCertSign);
            this.crlSign(model.crlSign);
            this.encipherOnly(model.encipherOnly);
            this.decipherOnly(model.decipherOnly);
        }

        public final Boolean getDigitalSignature() {
            return this.digitalSignature;
        }

        @Override
        public final Builder digitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
            return this;
        }

        public final void setDigitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
        }

        public final Boolean getNonRepudiation() {
            return this.nonRepudiation;
        }

        @Override
        public final Builder nonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
            return this;
        }

        public final void setNonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
        }

        public final Boolean getKeyEncipherment() {
            return this.keyEncipherment;
        }

        @Override
        public final Builder keyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
            return this;
        }

        public final void setKeyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
        }

        public final Boolean getDataEncipherment() {
            return this.dataEncipherment;
        }

        @Override
        public final Builder dataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
            return this;
        }

        public final void setDataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
        }

        public final Boolean getKeyAgreement() {
            return this.keyAgreement;
        }

        @Override
        public final Builder keyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public final void setKeyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
        }

        public final Boolean getKeyCertSign() {
            return this.keyCertSign;
        }

        @Override
        public final Builder keyCertSign(Boolean keyCertSign) {
            this.keyCertSign = keyCertSign;
            return this;
        }

        public final void setKeyCertSign(Boolean keyCertSign) {
            this.keyCertSign = keyCertSign;
        }

        public final Boolean getCrlSign() {
            return this.crlSign;
        }

        @Override
        public final Builder crlSign(Boolean crlSign) {
            this.crlSign = crlSign;
            return this;
        }

        public final void setCrlSign(Boolean crlSign) {
            this.crlSign = crlSign;
        }

        public final Boolean getEncipherOnly() {
            return this.encipherOnly;
        }

        @Override
        public final Builder encipherOnly(Boolean encipherOnly) {
            this.encipherOnly = encipherOnly;
            return this;
        }

        public final void setEncipherOnly(Boolean encipherOnly) {
            this.encipherOnly = encipherOnly;
        }

        public final Boolean getDecipherOnly() {
            return this.decipherOnly;
        }

        @Override
        public final Builder decipherOnly(Boolean decipherOnly) {
            this.decipherOnly = decipherOnly;
            return this;
        }

        public final void setDecipherOnly(Boolean decipherOnly) {
            this.decipherOnly = decipherOnly;
        }

        public KeyUsage build() {
            return new KeyUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyUsage> {
        public Builder digitalSignature(Boolean var1);

        public Builder nonRepudiation(Boolean var1);

        public Builder keyEncipherment(Boolean var1);

        public Builder dataEncipherment(Boolean var1);

        public Builder keyAgreement(Boolean var1);

        public Builder keyCertSign(Boolean var1);

        public Builder crlSign(Boolean var1);

        public Builder encipherOnly(Boolean var1);

        public Builder decipherOnly(Boolean var1);
    }
}

