/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportCertificateAuthorityCertificateRequest extends AcmPcaRequest implements
        ToCopyableBuilder<ImportCertificateAuthorityCertificateRequest.Builder, ImportCertificateAuthorityCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn")
            .getter(getter(ImportCertificateAuthorityCertificateRequest::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<SdkBytes> CERTIFICATE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Certificate").getter(getter(ImportCertificateAuthorityCertificateRequest::certificate))
            .setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<SdkBytes> CERTIFICATE_CHAIN_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("CertificateChain").getter(getter(ImportCertificateAuthorityCertificateRequest::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD));

    private final String certificateAuthorityArn;

    private final SdkBytes certificate;

    private final SdkBytes certificateChain;

    private ImportCertificateAuthorityCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html"
     * >CreateCertificateAuthority</a>. This must be of the form:
     * </p>
     * <p>
     * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html"
     *         >CreateCertificateAuthority</a>. This must be of the form: </p>
     *         <p>
     *         <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or
     * it may be signed by another CA that you control.
     * </p>
     * 
     * @return The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root
     *         CA, or it may be signed by another CA that you control.
     */
    public final SdkBytes certificate() {
        return certificate;
    }

    /**
     * <p>
     * A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining
     * up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each
     * certificate in the chain signs the one preceding.
     * </p>
     * <p>
     * This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.
     * </p>
     * 
     * @return A PEM-encoded file that contains all of your certificates, other than the certificate you're importing,
     *         chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in
     *         the chain, and each certificate in the chain signs the one preceding. </p>
     *         <p>
     *         This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no
     *         chain.
     */
    public final SdkBytes certificateChain() {
        return certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateAuthorityCertificateRequest)) {
            return false;
        }
        ImportCertificateAuthorityCertificateRequest other = (ImportCertificateAuthorityCertificateRequest) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(certificate(), other.certificate())
                && Objects.equals(certificateChain(), other.certificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportCertificateAuthorityCertificateRequest")
                .add("CertificateAuthorityArn", certificateAuthorityArn()).add("Certificate", certificate())
                .add("CertificateChain", certificateChain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateAuthorityCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateAuthorityCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportCertificateAuthorityCertificateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html"
         * >CreateCertificateAuthority</a>. This must be of the form:
         * </p>
         * <p>
         * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html"
         *        >CreateCertificateAuthority</a>. This must be of the form: </p>
         *        <p>
         *        <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA,
         * or it may be signed by another CA that you control.
         * </p>
         * 
         * @param certificate
         *        The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a
         *        root CA, or it may be signed by another CA that you control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(SdkBytes certificate);

        /**
         * <p>
         * A PEM-encoded file that contains all of your certificates, other than the certificate you're importing,
         * chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the
         * chain, and each certificate in the chain signs the one preceding.
         * </p>
         * <p>
         * This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no
         * chain.
         * </p>
         * 
         * @param certificateChain
         *        A PEM-encoded file that contains all of your certificates, other than the certificate you're
         *        importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is
         *        the last in the chain, and each certificate in the chain signs the one preceding. </p>
         *        <p>
         *        This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is
         *        no chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(SdkBytes certificateChain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private SdkBytes certificate;

        private SdkBytes certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateAuthorityCertificateRequest model) {
            super(model);
            certificateAuthorityArn(model.certificateAuthorityArn);
            certificate(model.certificate);
            certificateChain(model.certificateChain);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final ByteBuffer getCertificate() {
            return certificate == null ? null : certificate.asByteBuffer();
        }

        @Override
        public final Builder certificate(SdkBytes certificate) {
            this.certificate = StandardMemberCopier.copy(certificate);
            return this;
        }

        public final void setCertificate(ByteBuffer certificate) {
            certificate(certificate == null ? null : SdkBytes.fromByteBuffer(certificate));
        }

        public final ByteBuffer getCertificateChain() {
            return certificateChain == null ? null : certificateChain.asByteBuffer();
        }

        @Override
        public final Builder certificateChain(SdkBytes certificateChain) {
            this.certificateChain = StandardMemberCopier.copy(certificateChain);
            return this;
        }

        public final void setCertificateChain(ByteBuffer certificateChain) {
            certificateChain(certificateChain == null ? null : SdkBytes.fromByteBuffer(certificateChain));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateAuthorityCertificateRequest build() {
            return new ImportCertificateAuthorityCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
