/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains X.509 extension information for a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Extensions implements SdkPojo, Serializable, ToCopyableBuilder<Extensions.Builder, Extensions> {
    private static final SdkField<List<PolicyInformation>> CERTIFICATE_POLICIES_FIELD = SdkField
            .<List<PolicyInformation>> builder(MarshallingType.LIST)
            .memberName("CertificatePolicies")
            .getter(getter(Extensions::certificatePolicies))
            .setter(setter(Builder::certificatePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExtendedKeyUsage>> EXTENDED_KEY_USAGE_FIELD = SdkField
            .<List<ExtendedKeyUsage>> builder(MarshallingType.LIST)
            .memberName("ExtendedKeyUsage")
            .getter(getter(Extensions::extendedKeyUsage))
            .setter(setter(Builder::extendedKeyUsage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExtendedKeyUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExtendedKeyUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KeyUsage> KEY_USAGE_FIELD = SdkField.<KeyUsage> builder(MarshallingType.SDK_POJO)
            .memberName("KeyUsage").getter(getter(Extensions::keyUsage)).setter(setter(Builder::keyUsage))
            .constructor(KeyUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()).build();

    private static final SdkField<List<GeneralName>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField
            .<List<GeneralName>> builder(MarshallingType.LIST)
            .memberName("SubjectAlternativeNames")
            .getter(getter(Extensions::subjectAlternativeNames))
            .setter(setter(Builder::subjectAlternativeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeneralName> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeneralName::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_POLICIES_FIELD,
            EXTENDED_KEY_USAGE_FIELD, KEY_USAGE_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PolicyInformation> certificatePolicies;

    private final List<ExtendedKeyUsage> extendedKeyUsage;

    private final KeyUsage keyUsage;

    private final List<GeneralName> subjectAlternativeNames;

    private Extensions(BuilderImpl builder) {
        this.certificatePolicies = builder.certificatePolicies;
        this.extendedKeyUsage = builder.extendedKeyUsage;
        this.keyUsage = builder.keyUsage;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
    }

    /**
     * Returns true if the CertificatePolicies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCertificatePolicies() {
        return certificatePolicies != null && !(certificatePolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID)
     * and optional qualifiers. For more information, see NIST's definition of <a
     * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
     * </p>
     * <p>
     * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the
     * purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification
     * paths that include this certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificatePolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a sequence of one or more policy information terms, each of which consists of an object
     *         identifier (OID) and optional qualifiers. For more information, see NIST's definition of <a
     *         href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p>
     *         <p>
     *         In an end-entity certificate, these terms indicate the policy under which the certificate was issued and
     *         the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for
     *         certification paths that include this certificate.
     */
    public final List<PolicyInformation> certificatePolicies() {
        return certificatePolicies;
    }

    /**
     * Returns true if the ExtendedKeyUsage property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExtendedKeyUsage() {
        return extendedKeyUsage != null && !(extendedKeyUsage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies additional purposes for which the certified public key may be used other than basic purposes indicated
     * in the <code>KeyUsage</code> extension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExtendedKeyUsage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies additional purposes for which the certified public key may be used other than basic purposes
     *         indicated in the <code>KeyUsage</code> extension.
     */
    public final List<ExtendedKeyUsage> extendedKeyUsage() {
        return extendedKeyUsage;
    }

    /**
     * Returns the value of the KeyUsage property for this object.
     * 
     * @return The value of the KeyUsage property for this object.
     */
    public final KeyUsage keyUsage() {
        return keyUsage;
    }

    /**
     * Returns true if the SubjectAlternativeNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSubjectAlternativeNames() {
        return subjectAlternativeNames != null && !(subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subject alternative name extension allows identities to be bound to the subject of the certificate. These
     * identities may be included in addition to or in place of the identity in the subject field of the certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubjectAlternativeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The subject alternative name extension allows identities to be bound to the subject of the certificate.
     *         These identities may be included in addition to or in place of the identity in the subject field of the
     *         certificate.
     */
    public final List<GeneralName> subjectAlternativeNames() {
        return subjectAlternativeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificatePolicies() ? certificatePolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExtendedKeyUsage() ? extendedKeyUsage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(keyUsage());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjectAlternativeNames() ? subjectAlternativeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extensions)) {
            return false;
        }
        Extensions other = (Extensions) obj;
        return hasCertificatePolicies() == other.hasCertificatePolicies()
                && Objects.equals(certificatePolicies(), other.certificatePolicies())
                && hasExtendedKeyUsage() == other.hasExtendedKeyUsage()
                && Objects.equals(extendedKeyUsage(), other.extendedKeyUsage()) && Objects.equals(keyUsage(), other.keyUsage())
                && hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames()
                && Objects.equals(subjectAlternativeNames(), other.subjectAlternativeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Extensions").add("CertificatePolicies", hasCertificatePolicies() ? certificatePolicies() : null)
                .add("ExtendedKeyUsage", hasExtendedKeyUsage() ? extendedKeyUsage() : null).add("KeyUsage", keyUsage())
                .add("SubjectAlternativeNames", hasSubjectAlternativeNames() ? subjectAlternativeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificatePolicies":
            return Optional.ofNullable(clazz.cast(certificatePolicies()));
        case "ExtendedKeyUsage":
            return Optional.ofNullable(clazz.cast(extendedKeyUsage()));
        case "KeyUsage":
            return Optional.ofNullable(clazz.cast(keyUsage()));
        case "SubjectAlternativeNames":
            return Optional.ofNullable(clazz.cast(subjectAlternativeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Extensions, T> g) {
        return obj -> g.apply((Extensions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Extensions> {
        /**
         * <p>
         * Contains a sequence of one or more policy information terms, each of which consists of an object identifier
         * (OID) and optional qualifiers. For more information, see NIST's definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * <p>
         * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the
         * purposes for which it may be used. In a CA certificate, these terms limit the set of policies for
         * certification paths that include this certificate.
         * </p>
         * 
         * @param certificatePolicies
         *        Contains a sequence of one or more policy information terms, each of which consists of an object
         *        identifier (OID) and optional qualifiers. For more information, see NIST's definition of <a
         *        href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p>
         *        <p>
         *        In an end-entity certificate, these terms indicate the policy under which the certificate was issued
         *        and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies
         *        for certification paths that include this certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePolicies(Collection<PolicyInformation> certificatePolicies);

        /**
         * <p>
         * Contains a sequence of one or more policy information terms, each of which consists of an object identifier
         * (OID) and optional qualifiers. For more information, see NIST's definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * <p>
         * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the
         * purposes for which it may be used. In a CA certificate, these terms limit the set of policies for
         * certification paths that include this certificate.
         * </p>
         * 
         * @param certificatePolicies
         *        Contains a sequence of one or more policy information terms, each of which consists of an object
         *        identifier (OID) and optional qualifiers. For more information, see NIST's definition of <a
         *        href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p>
         *        <p>
         *        In an end-entity certificate, these terms indicate the policy under which the certificate was issued
         *        and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies
         *        for certification paths that include this certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePolicies(PolicyInformation... certificatePolicies);

        /**
         * <p>
         * Contains a sequence of one or more policy information terms, each of which consists of an object identifier
         * (OID) and optional qualifiers. For more information, see NIST's definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * <p>
         * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the
         * purposes for which it may be used. In a CA certificate, these terms limit the set of policies for
         * certification paths that include this certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyInformation>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #certificatePolicies(List<PolicyInformation>)}.
         * 
         * @param certificatePolicies
         *        a consumer that will call methods on {@link List<PolicyInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificatePolicies(List<PolicyInformation>)
         */
        Builder certificatePolicies(Consumer<PolicyInformation.Builder>... certificatePolicies);

        /**
         * <p>
         * Specifies additional purposes for which the certified public key may be used other than basic purposes
         * indicated in the <code>KeyUsage</code> extension.
         * </p>
         * 
         * @param extendedKeyUsage
         *        Specifies additional purposes for which the certified public key may be used other than basic purposes
         *        indicated in the <code>KeyUsage</code> extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsage(Collection<ExtendedKeyUsage> extendedKeyUsage);

        /**
         * <p>
         * Specifies additional purposes for which the certified public key may be used other than basic purposes
         * indicated in the <code>KeyUsage</code> extension.
         * </p>
         * 
         * @param extendedKeyUsage
         *        Specifies additional purposes for which the certified public key may be used other than basic purposes
         *        indicated in the <code>KeyUsage</code> extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsage(ExtendedKeyUsage... extendedKeyUsage);

        /**
         * <p>
         * Specifies additional purposes for which the certified public key may be used other than basic purposes
         * indicated in the <code>KeyUsage</code> extension.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExtendedKeyUsage>.Builder} avoiding the
         * need to create one manually via {@link List<ExtendedKeyUsage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExtendedKeyUsage>.Builder#build()} is called immediately and
         * its result is passed to {@link #extendedKeyUsage(List<ExtendedKeyUsage>)}.
         * 
         * @param extendedKeyUsage
         *        a consumer that will call methods on {@link List<ExtendedKeyUsage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedKeyUsage(List<ExtendedKeyUsage>)
         */
        Builder extendedKeyUsage(Consumer<ExtendedKeyUsage.Builder>... extendedKeyUsage);

        /**
         * Sets the value of the KeyUsage property for this object.
         *
         * @param keyUsage
         *        The new value for the KeyUsage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsage(KeyUsage keyUsage);

        /**
         * Sets the value of the KeyUsage property for this object.
         *
         * This is a convenience that creates an instance of the {@link KeyUsage.Builder} avoiding the need to create
         * one manually via {@link KeyUsage#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyUsage.Builder#build()} is called immediately and its result is
         * passed to {@link #keyUsage(KeyUsage)}.
         * 
         * @param keyUsage
         *        a consumer that will call methods on {@link KeyUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyUsage(KeyUsage)
         */
        default Builder keyUsage(Consumer<KeyUsage.Builder> keyUsage) {
            return keyUsage(KeyUsage.builder().applyMutation(keyUsage).build());
        }

        /**
         * <p>
         * The subject alternative name extension allows identities to be bound to the subject of the certificate. These
         * identities may be included in addition to or in place of the identity in the subject field of the
         * certificate.
         * </p>
         * 
         * @param subjectAlternativeNames
         *        The subject alternative name extension allows identities to be bound to the subject of the
         *        certificate. These identities may be included in addition to or in place of the identity in the
         *        subject field of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectAlternativeNames(Collection<GeneralName> subjectAlternativeNames);

        /**
         * <p>
         * The subject alternative name extension allows identities to be bound to the subject of the certificate. These
         * identities may be included in addition to or in place of the identity in the subject field of the
         * certificate.
         * </p>
         * 
         * @param subjectAlternativeNames
         *        The subject alternative name extension allows identities to be bound to the subject of the
         *        certificate. These identities may be included in addition to or in place of the identity in the
         *        subject field of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectAlternativeNames(GeneralName... subjectAlternativeNames);

        /**
         * <p>
         * The subject alternative name extension allows identities to be bound to the subject of the certificate. These
         * identities may be included in addition to or in place of the identity in the subject field of the
         * certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GeneralName>.Builder} avoiding the need to
         * create one manually via {@link List<GeneralName>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GeneralName>.Builder#build()} is called immediately and its
         * result is passed to {@link #subjectAlternativeNames(List<GeneralName>)}.
         * 
         * @param subjectAlternativeNames
         *        a consumer that will call methods on {@link List<GeneralName>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjectAlternativeNames(List<GeneralName>)
         */
        Builder subjectAlternativeNames(Consumer<GeneralName.Builder>... subjectAlternativeNames);
    }

    static final class BuilderImpl implements Builder {
        private List<PolicyInformation> certificatePolicies = DefaultSdkAutoConstructList.getInstance();

        private List<ExtendedKeyUsage> extendedKeyUsage = DefaultSdkAutoConstructList.getInstance();

        private KeyUsage keyUsage;

        private List<GeneralName> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Extensions model) {
            certificatePolicies(model.certificatePolicies);
            extendedKeyUsage(model.extendedKeyUsage);
            keyUsage(model.keyUsage);
            subjectAlternativeNames(model.subjectAlternativeNames);
        }

        public final Collection<PolicyInformation.Builder> getCertificatePolicies() {
            if (certificatePolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return certificatePolicies != null ? certificatePolicies.stream().map(PolicyInformation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificatePolicies(Collection<PolicyInformation> certificatePolicies) {
            this.certificatePolicies = CertificatePolicyListCopier.copy(certificatePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatePolicies(PolicyInformation... certificatePolicies) {
            certificatePolicies(Arrays.asList(certificatePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatePolicies(Consumer<PolicyInformation.Builder>... certificatePolicies) {
            certificatePolicies(Stream.of(certificatePolicies).map(c -> PolicyInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCertificatePolicies(Collection<PolicyInformation.BuilderImpl> certificatePolicies) {
            this.certificatePolicies = CertificatePolicyListCopier.copyFromBuilder(certificatePolicies);
        }

        public final Collection<ExtendedKeyUsage.Builder> getExtendedKeyUsage() {
            if (extendedKeyUsage instanceof SdkAutoConstructList) {
                return null;
            }
            return extendedKeyUsage != null ? extendedKeyUsage.stream().map(ExtendedKeyUsage::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extendedKeyUsage(Collection<ExtendedKeyUsage> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageListCopier.copy(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(ExtendedKeyUsage... extendedKeyUsage) {
            extendedKeyUsage(Arrays.asList(extendedKeyUsage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(Consumer<ExtendedKeyUsage.Builder>... extendedKeyUsage) {
            extendedKeyUsage(Stream.of(extendedKeyUsage).map(c -> ExtendedKeyUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExtendedKeyUsage(Collection<ExtendedKeyUsage.BuilderImpl> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageListCopier.copyFromBuilder(extendedKeyUsage);
        }

        public final KeyUsage.Builder getKeyUsage() {
            return keyUsage != null ? keyUsage.toBuilder() : null;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        public final void setKeyUsage(KeyUsage.BuilderImpl keyUsage) {
            this.keyUsage = keyUsage != null ? keyUsage.build() : null;
        }

        public final Collection<GeneralName.Builder> getSubjectAlternativeNames() {
            if (subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return subjectAlternativeNames != null ? subjectAlternativeNames.stream().map(GeneralName::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<GeneralName> subjectAlternativeNames) {
            this.subjectAlternativeNames = GeneralNameListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(GeneralName... subjectAlternativeNames) {
            subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(Consumer<GeneralName.Builder>... subjectAlternativeNames) {
            subjectAlternativeNames(Stream.of(subjectAlternativeNames).map(c -> GeneralName.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<GeneralName.BuilderImpl> subjectAlternativeNames) {
            this.subjectAlternativeNames = GeneralNameListCopier.copyFromBuilder(subjectAlternativeNames);
        }

        @Override
        public Extensions build() {
            return new Extensions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
