/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaResponse;
import software.amazon.awssdk.services.acmpca.model.AuditReportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCertificateAuthorityAuditReportResponse
extends AcmPcaResponse
implements ToCopyableBuilder<Builder, DescribeCertificateAuthorityAuditReportResponse> {
    private static final SdkField<String> AUDIT_REPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditReportStatus").getter(DescribeCertificateAuthorityAuditReportResponse.getter(DescribeCertificateAuthorityAuditReportResponse::auditReportStatusAsString)).setter(DescribeCertificateAuthorityAuditReportResponse.setter(Builder::auditReportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditReportStatus").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(DescribeCertificateAuthorityAuditReportResponse.getter(DescribeCertificateAuthorityAuditReportResponse::s3BucketName)).setter(DescribeCertificateAuthorityAuditReportResponse.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Key").getter(DescribeCertificateAuthorityAuditReportResponse.getter(DescribeCertificateAuthorityAuditReportResponse::s3Key)).setter(DescribeCertificateAuthorityAuditReportResponse.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeCertificateAuthorityAuditReportResponse.getter(DescribeCertificateAuthorityAuditReportResponse::createdAt)).setter(DescribeCertificateAuthorityAuditReportResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_REPORT_STATUS_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_FIELD, CREATED_AT_FIELD));
    private final String auditReportStatus;
    private final String s3BucketName;
    private final String s3Key;
    private final Instant createdAt;

    private DescribeCertificateAuthorityAuditReportResponse(BuilderImpl builder) {
        super(builder);
        this.auditReportStatus = builder.auditReportStatus;
        this.s3BucketName = builder.s3BucketName;
        this.s3Key = builder.s3Key;
        this.createdAt = builder.createdAt;
    }

    public final AuditReportStatus auditReportStatus() {
        return AuditReportStatus.fromValue(this.auditReportStatus);
    }

    public final String auditReportStatusAsString() {
        return this.auditReportStatus;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.auditReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateAuthorityAuditReportResponse)) {
            return false;
        }
        DescribeCertificateAuthorityAuditReportResponse other = (DescribeCertificateAuthorityAuditReportResponse)((Object)obj);
        return Objects.equals(this.auditReportStatusAsString(), other.auditReportStatusAsString()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCertificateAuthorityAuditReportResponse").add("AuditReportStatus", (Object)this.auditReportStatusAsString()).add("S3BucketName", (Object)this.s3BucketName()).add("S3Key", (Object)this.s3Key()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuditReportStatus": {
                return Optional.ofNullable(clazz.cast(this.auditReportStatusAsString()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCertificateAuthorityAuditReportResponse, T> g) {
        return obj -> g.apply((DescribeCertificateAuthorityAuditReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaResponse.BuilderImpl
    implements Builder {
        private String auditReportStatus;
        private String s3BucketName;
        private String s3Key;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateAuthorityAuditReportResponse model) {
            super(model);
            this.auditReportStatus(model.auditReportStatus);
            this.s3BucketName(model.s3BucketName);
            this.s3Key(model.s3Key);
            this.createdAt(model.createdAt);
        }

        public final String getAuditReportStatus() {
            return this.auditReportStatus;
        }

        @Override
        public final Builder auditReportStatus(String auditReportStatus) {
            this.auditReportStatus = auditReportStatus;
            return this;
        }

        @Override
        public final Builder auditReportStatus(AuditReportStatus auditReportStatus) {
            this.auditReportStatus(auditReportStatus == null ? null : auditReportStatus.toString());
            return this;
        }

        public final void setAuditReportStatus(String auditReportStatus) {
            this.auditReportStatus = auditReportStatus;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public DescribeCertificateAuthorityAuditReportResponse build() {
            return new DescribeCertificateAuthorityAuditReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCertificateAuthorityAuditReportResponse> {
        public Builder auditReportStatus(String var1);

        public Builder auditReportStatus(AuditReportStatus var1);

        public Builder s3BucketName(String var1);

        public Builder s3Key(String var1);

        public Builder createdAt(Instant var1);
    }
}

