/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.ResourceOwner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificateAuthoritiesRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, ListCertificateAuthoritiesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCertificateAuthoritiesRequest.getter(ListCertificateAuthoritiesRequest::nextToken)).setter(ListCertificateAuthoritiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCertificateAuthoritiesRequest.getter(ListCertificateAuthoritiesRequest::maxResults)).setter(ListCertificateAuthoritiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(ListCertificateAuthoritiesRequest.getter(ListCertificateAuthoritiesRequest::resourceOwnerAsString)).setter(ListCertificateAuthoritiesRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_OWNER_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String resourceOwner;

    private ListCertificateAuthoritiesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceOwner = builder.resourceOwner;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateAuthoritiesRequest)) {
            return false;
        }
        ListCertificateAuthoritiesRequest other = (ListCertificateAuthoritiesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListCertificateAuthoritiesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResourceOwner", (Object)this.resourceOwnerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateAuthoritiesRequest, T> g) {
        return obj -> g.apply((ListCertificateAuthoritiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateAuthoritiesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resourceOwner(model.resourceOwner);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCertificateAuthoritiesRequest build() {
            return new ListCertificateAuthoritiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificateAuthoritiesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

