/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.acmpca.AcmPcaClient;
import software.amazon.awssdk.services.acmpca.model.AcmPcaException;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.CertificateMismatchException;
import software.amazon.awssdk.services.acmpca.model.ConcurrentModificationException;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePolicyResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetPolicyRequest;
import software.amazon.awssdk.services.acmpca.model.GetPolicyResponse;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.InvalidArgsException;
import software.amazon.awssdk.services.acmpca.model.InvalidArnException;
import software.amazon.awssdk.services.acmpca.model.InvalidNextTokenException;
import software.amazon.awssdk.services.acmpca.model.InvalidPolicyException;
import software.amazon.awssdk.services.acmpca.model.InvalidRequestException;
import software.amazon.awssdk.services.acmpca.model.InvalidStateException;
import software.amazon.awssdk.services.acmpca.model.InvalidTagException;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.LimitExceededException;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse;
import software.amazon.awssdk.services.acmpca.model.ListTagsRequest;
import software.amazon.awssdk.services.acmpca.model.ListTagsResponse;
import software.amazon.awssdk.services.acmpca.model.LockoutPreventedException;
import software.amazon.awssdk.services.acmpca.model.MalformedCertificateException;
import software.amazon.awssdk.services.acmpca.model.MalformedCsrException;
import software.amazon.awssdk.services.acmpca.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.acmpca.model.PutPolicyRequest;
import software.amazon.awssdk.services.acmpca.model.PutPolicyResponse;
import software.amazon.awssdk.services.acmpca.model.RequestAlreadyProcessedException;
import software.amazon.awssdk.services.acmpca.model.RequestFailedException;
import software.amazon.awssdk.services.acmpca.model.RequestInProgressException;
import software.amazon.awssdk.services.acmpca.model.ResourceNotFoundException;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.TooManyTagsException;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable;
import software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable;
import software.amazon.awssdk.services.acmpca.transform.CreateCertificateAuthorityAuditReportRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.CreateCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.CreatePermissionRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeleteCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeletePermissionRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DescribeCertificateAuthorityAuditReportRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DescribeCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateAuthorityCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateAuthorityCsrRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ImportCertificateAuthorityCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.IssueCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.PutPolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.RestoreCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.RevokeCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.TagCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.UntagCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.UpdateCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.waiters.AcmPcaWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAcmPcaClient
implements AcmPcaClient {
    private static final Logger log = Logger.loggerFor(DefaultAcmPcaClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAcmPcaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "acm-pca";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCertificateAuthorityResponse createCertificateAuthority(CreateCertificateAuthorityRequest createCertificateAuthorityRequest) throws InvalidArgsException, InvalidPolicyException, InvalidTagException, LimitExceededException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, createCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificateAuthority");
            CreateCertificateAuthorityResponse createCertificateAuthorityResponse = (CreateCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$createCertificateAuthority$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCertificateAuthorityAuditReportResponse createCertificateAuthorityAuditReport(CreateCertificateAuthorityAuditReportRequest createCertificateAuthorityAuditReportRequest) throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException, InvalidArgsException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateAuthorityAuditReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, createCertificateAuthorityAuditReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificateAuthorityAuditReport");
            CreateCertificateAuthorityAuditReportResponse createCertificateAuthorityAuditReportResponse = (CreateCertificateAuthorityAuditReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificateAuthorityAuditReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCertificateAuthorityAuditReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCertificateAuthorityAuditReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCertificateAuthorityAuditReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$createCertificateAuthorityAuditReport$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePermissionResponse createPermission(CreatePermissionRequest createPermissionRequest) throws ResourceNotFoundException, InvalidArnException, PermissionAlreadyExistsException, LimitExceededException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, createPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermission");
            CreatePermissionResponse createPermissionResponse = (CreatePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$createPermission$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCertificateAuthorityResponse deleteCertificateAuthority(DeleteCertificateAuthorityRequest deleteCertificateAuthorityRequest) throws ConcurrentModificationException, ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, deleteCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificateAuthority");
            DeleteCertificateAuthorityResponse deleteCertificateAuthorityResponse = (DeleteCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$deleteCertificateAuthority$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionResponse deletePermission(DeletePermissionRequest deletePermissionRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, deletePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermission");
            DeletePermissionResponse deletePermissionResponse = (DeletePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$deletePermission$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ConcurrentModificationException, InvalidArnException, InvalidStateException, LockoutPreventedException, RequestFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            DeletePolicyResponse deletePolicyResponse = (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$deletePolicy$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificateAuthorityResponse describeCertificateAuthority(DescribeCertificateAuthorityRequest describeCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, describeCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificateAuthority");
            DescribeCertificateAuthorityResponse describeCertificateAuthorityResponse = (DescribeCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$describeCertificateAuthority$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificateAuthorityAuditReportResponse describeCertificateAuthorityAuditReport(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest) throws ResourceNotFoundException, InvalidArnException, InvalidArgsException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateAuthorityAuditReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, describeCertificateAuthorityAuditReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificateAuthorityAuditReport");
            DescribeCertificateAuthorityAuditReportResponse describeCertificateAuthorityAuditReportResponse = (DescribeCertificateAuthorityAuditReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificateAuthorityAuditReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCertificateAuthorityAuditReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificateAuthorityAuditReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificateAuthorityAuditReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$describeCertificateAuthorityAuditReport$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificateResponse getCertificate(GetCertificateRequest getCertificateRequest) throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, getCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificate");
            GetCertificateResponse getCertificateResponse = (GetCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getCertificate$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificateAuthorityCertificateResponse getCertificateAuthorityCertificate(GetCertificateAuthorityCertificateRequest getCertificateAuthorityCertificateRequest) throws ResourceNotFoundException, InvalidStateException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateAuthorityCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, getCertificateAuthorityCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificateAuthorityCertificate");
            GetCertificateAuthorityCertificateResponse getCertificateAuthorityCertificateResponse = (GetCertificateAuthorityCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificateAuthorityCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCertificateAuthorityCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificateAuthorityCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificateAuthorityCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getCertificateAuthorityCertificate$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificateAuthorityCsrResponse getCertificateAuthorityCsr(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest) throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateAuthorityCsrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, getCertificateAuthorityCsrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificateAuthorityCsr");
            GetCertificateAuthorityCsrResponse getCertificateAuthorityCsrResponse = (GetCertificateAuthorityCsrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificateAuthorityCsr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCertificateAuthorityCsrRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificateAuthorityCsrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificateAuthorityCsrResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getCertificateAuthorityCsr$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws InvalidArnException, InvalidStateException, RequestFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, getPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPolicy");
            GetPolicyResponse getPolicyResponse = (GetPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCertificateAuthorityCertificateResponse importCertificateAuthorityCertificate(ImportCertificateAuthorityCertificateRequest importCertificateAuthorityCertificateRequest) throws ConcurrentModificationException, RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException, InvalidRequestException, InvalidStateException, MalformedCertificateException, CertificateMismatchException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCertificateAuthorityCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, importCertificateAuthorityCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCertificateAuthorityCertificate");
            ImportCertificateAuthorityCertificateResponse importCertificateAuthorityCertificateResponse = (ImportCertificateAuthorityCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCertificateAuthorityCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importCertificateAuthorityCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportCertificateAuthorityCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importCertificateAuthorityCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$importCertificateAuthorityCertificate$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IssueCertificateResponse issueCertificate(IssueCertificateRequest issueCertificateRequest) throws LimitExceededException, ResourceNotFoundException, InvalidStateException, InvalidArnException, InvalidArgsException, MalformedCsrException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IssueCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, issueCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IssueCertificate");
            IssueCertificateResponse issueCertificateResponse = (IssueCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IssueCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)issueCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IssueCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return issueCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$issueCertificate$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCertificateAuthoritiesResponse listCertificateAuthorities(ListCertificateAuthoritiesRequest listCertificateAuthoritiesRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificateAuthoritiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, listCertificateAuthoritiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificateAuthorities");
            ListCertificateAuthoritiesResponse listCertificateAuthoritiesResponse = (ListCertificateAuthoritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificateAuthorities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCertificateAuthoritiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCertificateAuthoritiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCertificateAuthoritiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$listCertificateAuthorities$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCertificateAuthoritiesIterable listCertificateAuthoritiesPaginator(ListCertificateAuthoritiesRequest listCertificateAuthoritiesRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, AcmPcaException {
        return new ListCertificateAuthoritiesIterable(this, this.applyPaginatorUserAgent(listCertificateAuthoritiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws ResourceNotFoundException, InvalidArnException, InvalidNextTokenException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            ListPermissionsResponse listPermissionsResponse = (ListPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$listPermissions$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest) throws ResourceNotFoundException, InvalidArnException, InvalidNextTokenException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        return new ListPermissionsIterable(this, this.applyPaginatorUserAgent(listPermissionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$listTags$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        return new ListTagsIterable(this, this.applyPaginatorUserAgent(listTagsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPolicyResponse putPolicy(PutPolicyRequest putPolicyRequest) throws ConcurrentModificationException, InvalidArnException, InvalidStateException, InvalidPolicyException, LockoutPreventedException, RequestFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, putPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPolicy");
            PutPolicyResponse putPolicyResponse = (PutPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$putPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreCertificateAuthorityResponse restoreCertificateAuthority(RestoreCertificateAuthorityRequest restoreCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidStateException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, restoreCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreCertificateAuthority");
            RestoreCertificateAuthorityResponse restoreCertificateAuthorityResponse = (RestoreCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$restoreCertificateAuthority$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeCertificateResponse revokeCertificate(RevokeCertificateRequest revokeCertificateRequest) throws ConcurrentModificationException, InvalidArnException, InvalidRequestException, InvalidStateException, LimitExceededException, ResourceNotFoundException, RequestAlreadyProcessedException, RequestInProgressException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, revokeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeCertificate");
            RevokeCertificateResponse revokeCertificateResponse = (RevokeCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$revokeCertificate$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagCertificateAuthorityResponse tagCertificateAuthority(TagCertificateAuthorityRequest tagCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, InvalidTagException, TooManyTagsException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, tagCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagCertificateAuthority");
            TagCertificateAuthorityResponse tagCertificateAuthorityResponse = (TagCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$tagCertificateAuthority$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagCertificateAuthorityResponse untagCertificateAuthority(UntagCertificateAuthorityRequest untagCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, InvalidTagException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, untagCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagCertificateAuthority");
            UntagCertificateAuthorityResponse untagCertificateAuthorityResponse = (UntagCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$untagCertificateAuthority$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCertificateAuthorityResponse updateCertificateAuthority(UpdateCertificateAuthorityRequest updateCertificateAuthorityRequest) throws ConcurrentModificationException, ResourceNotFoundException, InvalidArgsException, InvalidArnException, InvalidStateException, InvalidPolicyException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(this.clientConfiguration, updateCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCertificateAuthority");
            UpdateCertificateAuthorityResponse updateCertificateAuthorityResponse = (UpdateCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$updateCertificateAuthority$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AcmPcaException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagException").exceptionBuilderSupplier(InvalidTagException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateMismatchException").exceptionBuilderSupplier(CertificateMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedCSRException").exceptionBuilderSupplier(MalformedCsrException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPolicyException").exceptionBuilderSupplier(InvalidPolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgsException").exceptionBuilderSupplier(InvalidArgsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArnException").exceptionBuilderSupplier(InvalidArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestInProgressException").exceptionBuilderSupplier(RequestInProgressException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LockoutPreventedException").exceptionBuilderSupplier(LockoutPreventedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateException").exceptionBuilderSupplier(InvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedCertificateException").exceptionBuilderSupplier(MalformedCertificateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestFailedException").exceptionBuilderSupplier(RequestFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AcmPcaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.17").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AcmPcaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public AcmPcaWaiter waiter() {
        return AcmPcaWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$updateCertificateAuthority$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagCertificateAuthority$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagCertificateAuthority$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeCertificate$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreCertificateAuthority$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCertificateAuthorities$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$issueCertificate$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCertificateAuthorityCertificate$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCsr$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCertificate$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificate$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificateAuthorityAuditReport$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificateAuthority$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicy$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermission$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificateAuthority$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermission$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificateAuthorityAuditReport$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificateAuthority$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

