/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Validity specifies the period of time during which a certificate is valid. Validity can be expressed as an explicit
 * date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years.
 * For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.
 * </p>
 * <p>
 * You can issue a certificate by calling the <a
 * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Validity implements SdkPojo, Serializable, ToCopyableBuilder<Validity.Builder, Validity> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Validity::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Validity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long value;

    private final String type;

    private Validity(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * A long integer interpreted according to the value of <code>Type</code>, below.
     * </p>
     * 
     * @return A long integer interpreted according to the value of <code>Type</code>, below.
     */
    public Long value() {
        return value;
    }

    /**
     * <p>
     * Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported validity
     * types include those listed below. Type definitions with values include a sample input value and the resulting
     * output.
     * </p>
     * <p>
     * <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using UTCTime
     * (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year field (YY) is
     * greater than or equal to 50, the year is interpreted as 19YY. If the year field is less than 50, the year is
     * interpreted as 20YY.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample input value: 491231235959 (UTCTime format)
     * </p>
     * </li>
     * <li>
     * <p>
     * Output expiration date/time: 12/31/2049 23:59:59
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in seconds since
     * the Unix Epoch.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample input value: 2524608000
     * </p>
     * </li>
     * <li>
     * <p>
     * Output expiration date/time: 01/01/2050 00:00:00
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance until
     * the certificate will expire, expressed in days, months, or years.
     * </p>
     * <p>
     * Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample input value: 90
     * </p>
     * </li>
     * <li>
     * <p>
     * Output expiration date: 01/10/2020 12:34:54 UTC
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ValidityPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported
     *         validity types include those listed below. Type definitions with values include a sample input value and
     *         the resulting output. </p>
     *         <p>
     *         <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using
     *         UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year
     *         field (YY) is greater than or equal to 50, the year is interpreted as 19YY. If the year field is less
     *         than 50, the year is interpreted as 20YY.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sample input value: 491231235959 (UTCTime format)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Output expiration date/time: 12/31/2049 23:59:59
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in seconds
     *         since the Unix Epoch.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sample input value: 2524608000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Output expiration date/time: 01/01/2050 00:00:00
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance
     *         until the certificate will expire, expressed in days, months, or years.
     *         </p>
     *         <p>
     *         Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sample input value: 90
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Output expiration date: 01/10/2020 12:34:54 UTC
     *         </p>
     *         </li>
     * @see ValidityPeriodType
     */
    public ValidityPeriodType type() {
        return ValidityPeriodType.fromValue(type);
    }

    /**
     * <p>
     * Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported validity
     * types include those listed below. Type definitions with values include a sample input value and the resulting
     * output.
     * </p>
     * <p>
     * <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using UTCTime
     * (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year field (YY) is
     * greater than or equal to 50, the year is interpreted as 19YY. If the year field is less than 50, the year is
     * interpreted as 20YY.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample input value: 491231235959 (UTCTime format)
     * </p>
     * </li>
     * <li>
     * <p>
     * Output expiration date/time: 12/31/2049 23:59:59
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in seconds since
     * the Unix Epoch.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample input value: 2524608000
     * </p>
     * </li>
     * <li>
     * <p>
     * Output expiration date/time: 01/01/2050 00:00:00
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance until
     * the certificate will expire, expressed in days, months, or years.
     * </p>
     * <p>
     * Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample input value: 90
     * </p>
     * </li>
     * <li>
     * <p>
     * Output expiration date: 01/10/2020 12:34:54 UTC
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ValidityPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported
     *         validity types include those listed below. Type definitions with values include a sample input value and
     *         the resulting output. </p>
     *         <p>
     *         <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using
     *         UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year
     *         field (YY) is greater than or equal to 50, the year is interpreted as 19YY. If the year field is less
     *         than 50, the year is interpreted as 20YY.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sample input value: 491231235959 (UTCTime format)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Output expiration date/time: 12/31/2049 23:59:59
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in seconds
     *         since the Unix Epoch.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sample input value: 2524608000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Output expiration date/time: 01/01/2050 00:00:00
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance
     *         until the certificate will expire, expressed in days, months, or years.
     *         </p>
     *         <p>
     *         Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sample input value: 90
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Output expiration date: 01/10/2020 12:34:54 UTC
     *         </p>
     *         </li>
     * @see ValidityPeriodType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Validity)) {
            return false;
        }
        Validity other = (Validity) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Validity").add("Value", value()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Validity, T> g) {
        return obj -> g.apply((Validity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Validity> {
        /**
         * <p>
         * A long integer interpreted according to the value of <code>Type</code>, below.
         * </p>
         * 
         * @param value
         *        A long integer interpreted according to the value of <code>Type</code>, below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported
         * validity types include those listed below. Type definitions with values include a sample input value and the
         * resulting output.
         * </p>
         * <p>
         * <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using UTCTime
         * (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year field (YY) is
         * greater than or equal to 50, the year is interpreted as 19YY. If the year field is less than 50, the year is
         * interpreted as 20YY.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sample input value: 491231235959 (UTCTime format)
         * </p>
         * </li>
         * <li>
         * <p>
         * Output expiration date/time: 12/31/2049 23:59:59
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in seconds
         * since the Unix Epoch.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sample input value: 2524608000
         * </p>
         * </li>
         * <li>
         * <p>
         * Output expiration date/time: 01/01/2050 00:00:00
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance
         * until the certificate will expire, expressed in days, months, or years.
         * </p>
         * <p>
         * Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sample input value: 90
         * </p>
         * </li>
         * <li>
         * <p>
         * Output expiration date: 01/10/2020 12:34:54 UTC
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer.
         *        Supported validity types include those listed below. Type definitions with values include a sample
         *        input value and the resulting output. </p>
         *        <p>
         *        <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using
         *        UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year
         *        field (YY) is greater than or equal to 50, the year is interpreted as 19YY. If the year field is less
         *        than 50, the year is interpreted as 20YY.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sample input value: 491231235959 (UTCTime format)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Output expiration date/time: 12/31/2049 23:59:59
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in
         *        seconds since the Unix Epoch.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sample input value: 2524608000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Output expiration date/time: 01/01/2050 00:00:00
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of
         *        issuance until the certificate will expire, expressed in days, months, or years.
         *        </p>
         *        <p>
         *        Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sample input value: 90
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Output expiration date: 01/10/2020 12:34:54 UTC
         *        </p>
         *        </li>
         * @see ValidityPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidityPeriodType
         */
        Builder type(String type);

        /**
         * <p>
         * Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported
         * validity types include those listed below. Type definitions with values include a sample input value and the
         * resulting output.
         * </p>
         * <p>
         * <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using UTCTime
         * (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year field (YY) is
         * greater than or equal to 50, the year is interpreted as 19YY. If the year field is less than 50, the year is
         * interpreted as 20YY.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sample input value: 491231235959 (UTCTime format)
         * </p>
         * </li>
         * <li>
         * <p>
         * Output expiration date/time: 12/31/2049 23:59:59
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in seconds
         * since the Unix Epoch.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sample input value: 2524608000
         * </p>
         * </li>
         * <li>
         * <p>
         * Output expiration date/time: 01/01/2050 00:00:00
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance
         * until the certificate will expire, expressed in days, months, or years.
         * </p>
         * <p>
         * Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sample input value: 90
         * </p>
         * </li>
         * <li>
         * <p>
         * Output expiration date: 01/10/2020 12:34:54 UTC
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer.
         *        Supported validity types include those listed below. Type definitions with values include a sample
         *        input value and the resulting output. </p>
         *        <p>
         *        <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using
         *        UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year
         *        field (YY) is greater than or equal to 50, the year is interpreted as 19YY. If the year field is less
         *        than 50, the year is interpreted as 20YY.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sample input value: 491231235959 (UTCTime format)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Output expiration date/time: 12/31/2049 23:59:59
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>ABSOLUTE</code>: The specific date and time when the certificate will expire, expressed in
         *        seconds since the Unix Epoch.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sample input value: 2524608000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Output expiration date/time: 01/01/2050 00:00:00
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of
         *        issuance until the certificate will expire, expressed in days, months, or years.
         *        </p>
         *        <p>
         *        Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sample input value: 90
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Output expiration date: 01/10/2020 12:34:54 UTC
         *        </p>
         *        </li>
         * @see ValidityPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidityPeriodType
         */
        Builder type(ValidityPeriodType type);
    }

    static final class BuilderImpl implements Builder {
        private Long value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Validity model) {
            value(model.value);
            type(model.type);
        }

        public final Long getValue() {
            return value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ValidityPeriodType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Validity build() {
            return new Validity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
