/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCertificateAuthorityCertificateResponse extends AcmPcaResponse implements
        ToCopyableBuilder<GetCertificateAuthorityCertificateResponse.Builder, GetCertificateAuthorityCertificateResponse> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCertificateAuthorityCertificateResponse::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCertificateAuthorityCertificateResponse::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD,
            CERTIFICATE_CHAIN_FIELD));

    private final String certificate;

    private final String certificateChain;

    private GetCertificateAuthorityCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
    }

    /**
     * <p>
     * Base64-encoded certificate authority (CA) certificate.
     * </p>
     * 
     * @return Base64-encoded certificate authority (CA) certificate.
     */
    public String certificate() {
        return certificate;
    }

    /**
     * <p>
     * Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises
     * certificate that you used to sign your private CA certificate. The chain does not include your private CA
     * certificate. If this is a root CA, the value will be null.
     * </p>
     * 
     * @return Base64-encoded certificate chain that includes any intermediate certificates and chains up to root
     *         on-premises certificate that you used to sign your private CA certificate. The chain does not include
     *         your private CA certificate. If this is a root CA, the value will be null.
     */
    public String certificateChain() {
        return certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificateAuthorityCertificateResponse)) {
            return false;
        }
        GetCertificateAuthorityCertificateResponse other = (GetCertificateAuthorityCertificateResponse) obj;
        return Objects.equals(certificate(), other.certificate()) && Objects.equals(certificateChain(), other.certificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCertificateAuthorityCertificateResponse").add("Certificate", certificate())
                .add("CertificateChain", certificateChain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificateAuthorityCertificateResponse, T> g) {
        return obj -> g.apply((GetCertificateAuthorityCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCertificateAuthorityCertificateResponse> {
        /**
         * <p>
         * Base64-encoded certificate authority (CA) certificate.
         * </p>
         * 
         * @param certificate
         *        Base64-encoded certificate authority (CA) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * Base64-encoded certificate chain that includes any intermediate certificates and chains up to root
         * on-premises certificate that you used to sign your private CA certificate. The chain does not include your
         * private CA certificate. If this is a root CA, the value will be null.
         * </p>
         * 
         * @param certificateChain
         *        Base64-encoded certificate chain that includes any intermediate certificates and chains up to root
         *        on-premises certificate that you used to sign your private CA certificate. The chain does not include
         *        your private CA certificate. If this is a root CA, the value will be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);
    }

    static final class BuilderImpl extends AcmPcaResponse.BuilderImpl implements Builder {
        private String certificate;

        private String certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificateAuthorityCertificateResponse model) {
            super(model);
            certificate(model.certificate);
            certificateChain(model.certificateChain);
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public GetCertificateAuthorityCertificateResponse build() {
            return new GetCertificateAuthorityCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
