/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ValidationMethod {
    EMAIL("EMAIL"),
    DNS("DNS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ValidationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ValidationMethod.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationMethod> knownValues() {
        return Stream.of(ValidationMethod.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

