/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.AcmResponse;
import software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountConfigurationResponse
extends AcmResponse
implements ToCopyableBuilder<Builder, GetAccountConfigurationResponse> {
    private static final SdkField<ExpiryEventsConfiguration> EXPIRY_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpiryEvents").getter(GetAccountConfigurationResponse.getter(GetAccountConfigurationResponse::expiryEvents)).setter(GetAccountConfigurationResponse.setter(Builder::expiryEvents)).constructor(ExpiryEventsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryEvents").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRY_EVENTS_FIELD));
    private final ExpiryEventsConfiguration expiryEvents;

    private GetAccountConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.expiryEvents = builder.expiryEvents;
    }

    public final ExpiryEventsConfiguration expiryEvents() {
        return this.expiryEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryEvents());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountConfigurationResponse)) {
            return false;
        }
        GetAccountConfigurationResponse other = (GetAccountConfigurationResponse)((Object)obj);
        return Objects.equals(this.expiryEvents(), other.expiryEvents());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountConfigurationResponse").add("ExpiryEvents", (Object)this.expiryEvents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpiryEvents": {
                return Optional.ofNullable(clazz.cast(this.expiryEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountConfigurationResponse, T> g) {
        return obj -> g.apply((GetAccountConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmResponse.BuilderImpl
    implements Builder {
        private ExpiryEventsConfiguration expiryEvents;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountConfigurationResponse model) {
            super(model);
            this.expiryEvents(model.expiryEvents);
        }

        public final ExpiryEventsConfiguration.Builder getExpiryEvents() {
            return this.expiryEvents != null ? this.expiryEvents.toBuilder() : null;
        }

        @Override
        public final Builder expiryEvents(ExpiryEventsConfiguration expiryEvents) {
            this.expiryEvents = expiryEvents;
            return this;
        }

        public final void setExpiryEvents(ExpiryEventsConfiguration.BuilderImpl expiryEvents) {
            this.expiryEvents = expiryEvents != null ? expiryEvents.build() : null;
        }

        @Override
        public GetAccountConfigurationResponse build() {
            return new GetAccountConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountConfigurationResponse> {
        public Builder expiryEvents(ExpiryEventsConfiguration var1);

        default public Builder expiryEvents(Consumer<ExpiryEventsConfiguration.Builder> expiryEvents) {
            return this.expiryEvents((ExpiryEventsConfiguration)((ExpiryEventsConfiguration.Builder)ExpiryEventsConfiguration.builder().applyMutation(expiryEvents)).build());
        }
    }
}

