/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.ImportCertificateRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> CERTIFICATECHAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateChain").isBinary(false).build();
    private static final ImportCertificateRequestModelMarshaller INSTANCE = new ImportCertificateRequestModelMarshaller();

    private ImportCertificateRequestModelMarshaller() {
    }

    public static ImportCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportCertificateRequest importCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)importCertificateRequest), (String)"importCertificateRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importCertificateRequest.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.certificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.privateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.certificateChain(), CERTIFICATECHAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

