/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm;

import java.util.function.Consumer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.acm.ACMClientBuilder;
import software.amazon.awssdk.services.acm.DefaultACMClientBuilder;
import software.amazon.awssdk.services.acm.model.ACMException;
import software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest;
import software.amazon.awssdk.services.acm.model.AddTagsToCertificateResponse;
import software.amazon.awssdk.services.acm.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.acm.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.acm.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.acm.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.acm.model.GetCertificateRequest;
import software.amazon.awssdk.services.acm.model.GetCertificateResponse;
import software.amazon.awssdk.services.acm.model.ImportCertificateRequest;
import software.amazon.awssdk.services.acm.model.ImportCertificateResponse;
import software.amazon.awssdk.services.acm.model.InvalidArnException;
import software.amazon.awssdk.services.acm.model.InvalidDomainValidationOptionsException;
import software.amazon.awssdk.services.acm.model.InvalidStateException;
import software.amazon.awssdk.services.acm.model.InvalidTagException;
import software.amazon.awssdk.services.acm.model.LimitExceededException;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesResponse;
import software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest;
import software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse;
import software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest;
import software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateResponse;
import software.amazon.awssdk.services.acm.model.RequestCertificateRequest;
import software.amazon.awssdk.services.acm.model.RequestCertificateResponse;
import software.amazon.awssdk.services.acm.model.RequestInProgressException;
import software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest;
import software.amazon.awssdk.services.acm.model.ResendValidationEmailResponse;
import software.amazon.awssdk.services.acm.model.ResourceInUseException;
import software.amazon.awssdk.services.acm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.acm.model.TooManyTagsException;
import software.amazon.awssdk.services.acm.paginators.ListCertificatesPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface ACMClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "acm";

    public static ACMClient create() {
        return (ACMClient)ACMClient.builder().build();
    }

    public static ACMClientBuilder builder() {
        return new DefaultACMClientBuilder();
    }

    default public AddTagsToCertificateResponse addTagsToCertificate(AddTagsToCertificateRequest addTagsToCertificateRequest) throws ResourceNotFoundException, InvalidArnException, InvalidTagException, TooManyTagsException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public AddTagsToCertificateResponse addTagsToCertificate(Consumer<AddTagsToCertificateRequest.Builder> addTagsToCertificateRequest) throws ResourceNotFoundException, InvalidArnException, InvalidTagException, TooManyTagsException, SdkServiceException, SdkClientException, ACMException {
        return this.addTagsToCertificate((AddTagsToCertificateRequest)((Object)((AddTagsToCertificateRequest.Builder)AddTagsToCertificateRequest.builder().apply(addTagsToCertificateRequest)).build()));
    }

    default public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public DeleteCertificateResponse deleteCertificate(Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        return this.deleteCertificate((DeleteCertificateRequest)((Object)((DeleteCertificateRequest.Builder)DeleteCertificateRequest.builder().apply(deleteCertificateRequest)).build()));
    }

    default public DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest) throws ResourceNotFoundException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public DescribeCertificateResponse describeCertificate(Consumer<DescribeCertificateRequest.Builder> describeCertificateRequest) throws ResourceNotFoundException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        return this.describeCertificate((DescribeCertificateRequest)((Object)((DescribeCertificateRequest.Builder)DescribeCertificateRequest.builder().apply(describeCertificateRequest)).build()));
    }

    default public GetCertificateResponse getCertificate(GetCertificateRequest getCertificateRequest) throws ResourceNotFoundException, RequestInProgressException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public GetCertificateResponse getCertificate(Consumer<GetCertificateRequest.Builder> getCertificateRequest) throws ResourceNotFoundException, RequestInProgressException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        return this.getCertificate((GetCertificateRequest)((Object)((GetCertificateRequest.Builder)GetCertificateRequest.builder().apply(getCertificateRequest)).build()));
    }

    default public ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest) throws ResourceNotFoundException, LimitExceededException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public ImportCertificateResponse importCertificate(Consumer<ImportCertificateRequest.Builder> importCertificateRequest) throws ResourceNotFoundException, LimitExceededException, SdkServiceException, SdkClientException, ACMException {
        return this.importCertificate((ImportCertificateRequest)((Object)((ImportCertificateRequest.Builder)ImportCertificateRequest.builder().apply(importCertificateRequest)).build()));
    }

    default public ListCertificatesResponse listCertificates() throws SdkServiceException, SdkClientException, ACMException {
        return this.listCertificates((ListCertificatesRequest)((Object)ListCertificatesRequest.builder().build()));
    }

    default public ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest) throws SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public ListCertificatesResponse listCertificates(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest) throws SdkServiceException, SdkClientException, ACMException {
        return this.listCertificates((ListCertificatesRequest)((Object)((ListCertificatesRequest.Builder)ListCertificatesRequest.builder().apply(listCertificatesRequest)).build()));
    }

    default public ListCertificatesPaginator listCertificatesIterable() throws SdkServiceException, SdkClientException, ACMException {
        return this.listCertificatesIterable((ListCertificatesRequest)((Object)ListCertificatesRequest.builder().build()));
    }

    default public ListCertificatesPaginator listCertificatesIterable(ListCertificatesRequest listCertificatesRequest) throws SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForCertificateResponse listTagsForCertificate(ListTagsForCertificateRequest listTagsForCertificateRequest) throws ResourceNotFoundException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForCertificateResponse listTagsForCertificate(Consumer<ListTagsForCertificateRequest.Builder> listTagsForCertificateRequest) throws ResourceNotFoundException, InvalidArnException, SdkServiceException, SdkClientException, ACMException {
        return this.listTagsForCertificate((ListTagsForCertificateRequest)((Object)((ListTagsForCertificateRequest.Builder)ListTagsForCertificateRequest.builder().apply(listTagsForCertificateRequest)).build()));
    }

    default public RemoveTagsFromCertificateResponse removeTagsFromCertificate(RemoveTagsFromCertificateRequest removeTagsFromCertificateRequest) throws ResourceNotFoundException, InvalidArnException, InvalidTagException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public RemoveTagsFromCertificateResponse removeTagsFromCertificate(Consumer<RemoveTagsFromCertificateRequest.Builder> removeTagsFromCertificateRequest) throws ResourceNotFoundException, InvalidArnException, InvalidTagException, SdkServiceException, SdkClientException, ACMException {
        return this.removeTagsFromCertificate((RemoveTagsFromCertificateRequest)((Object)((RemoveTagsFromCertificateRequest.Builder)RemoveTagsFromCertificateRequest.builder().apply(removeTagsFromCertificateRequest)).build()));
    }

    default public RequestCertificateResponse requestCertificate(RequestCertificateRequest requestCertificateRequest) throws LimitExceededException, InvalidDomainValidationOptionsException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public RequestCertificateResponse requestCertificate(Consumer<RequestCertificateRequest.Builder> requestCertificateRequest) throws LimitExceededException, InvalidDomainValidationOptionsException, SdkServiceException, SdkClientException, ACMException {
        return this.requestCertificate((RequestCertificateRequest)((Object)((RequestCertificateRequest.Builder)RequestCertificateRequest.builder().apply(requestCertificateRequest)).build()));
    }

    default public ResendValidationEmailResponse resendValidationEmail(ResendValidationEmailRequest resendValidationEmailRequest) throws ResourceNotFoundException, InvalidStateException, InvalidArnException, InvalidDomainValidationOptionsException, SdkServiceException, SdkClientException, ACMException {
        throw new UnsupportedOperationException();
    }

    default public ResendValidationEmailResponse resendValidationEmail(Consumer<ResendValidationEmailRequest.Builder> resendValidationEmailRequest) throws ResourceNotFoundException, InvalidStateException, InvalidArnException, InvalidDomainValidationOptionsException, SdkServiceException, SdkClientException, ACMException {
        return this.resendValidationEmail((ResendValidationEmailRequest)((Object)((ResendValidationEmailRequest.Builder)ResendValidationEmailRequest.builder().apply(resendValidationEmailRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

