/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.acm.model.CertificateSummary;
import software.amazon.awssdk.services.acm.model.CertificateSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCertificatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCertificatesResponse> {
    private final String nextToken;
    private final List<CertificateSummary> certificateSummaryList;

    private ListCertificatesResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.certificateSummaryList = builder.certificateSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<CertificateSummary> certificateSummaryList() {
        return this.certificateSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSummaryList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResponse)) {
            return false;
        }
        ListCertificatesResponse other = (ListCertificatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.certificateSummaryList(), other.certificateSummaryList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.certificateSummaryList() != null) {
            sb.append("CertificateSummaryList: ").append(this.certificateSummaryList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "CertificateSummaryList": {
                return Optional.of(clazz.cast(this.certificateSummaryList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CertificateSummary> certificateSummaryList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesResponse model) {
            this.nextToken(model.nextToken);
            this.certificateSummaryList(model.certificateSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CertificateSummary.Builder> getCertificateSummaryList() {
            return this.certificateSummaryList != null ? (Collection)this.certificateSummaryList.stream().map(CertificateSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificateSummaryList(Collection<CertificateSummary> certificateSummaryList) {
            this.certificateSummaryList = CertificateSummaryListCopier.copy(certificateSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateSummaryList(CertificateSummary ... certificateSummaryList) {
            this.certificateSummaryList(Arrays.asList(certificateSummaryList));
            return this;
        }

        public final void setCertificateSummaryList(Collection<CertificateSummary.BuilderImpl> certificateSummaryList) {
            this.certificateSummaryList = CertificateSummaryListCopier.copyFromBuilder(certificateSummaryList);
        }

        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCertificatesResponse> {
        public Builder nextToken(String var1);

        public Builder certificateSummaryList(Collection<CertificateSummary> var1);

        public Builder certificateSummaryList(CertificateSummary ... var1);
    }
}

