/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.DomainStatus;
import software.amazon.awssdk.services.acm.model.ValidationEmailListCopier;
import software.amazon.awssdk.services.acm.transform.DomainValidationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainValidation
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainValidation> {
    private final String domainName;
    private final List<String> validationEmails;
    private final String validationDomain;
    private final String validationStatus;

    private DomainValidation(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationEmails = builder.validationEmails;
        this.validationDomain = builder.validationDomain;
        this.validationStatus = builder.validationStatus;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> validationEmails() {
        return this.validationEmails;
    }

    public String validationDomain() {
        return this.validationDomain;
    }

    public DomainStatus validationStatus() {
        return DomainStatus.fromValue(this.validationStatus);
    }

    public String validationStatusString() {
        return this.validationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationEmails());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidation)) {
            return false;
        }
        DomainValidation other = (DomainValidation)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.validationEmails(), other.validationEmails()) && Objects.equals(this.validationDomain(), other.validationDomain()) && Objects.equals(this.validationStatusString(), other.validationStatusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.validationEmails() != null) {
            sb.append("ValidationEmails: ").append(this.validationEmails()).append(",");
        }
        if (this.validationDomain() != null) {
            sb.append("ValidationDomain: ").append(this.validationDomain()).append(",");
        }
        if (this.validationStatusString() != null) {
            sb.append("ValidationStatus: ").append(this.validationStatusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ValidationEmails": {
                return Optional.of(clazz.cast(this.validationEmails()));
            }
            case "ValidationDomain": {
                return Optional.of(clazz.cast(this.validationDomain()));
            }
            case "ValidationStatus": {
                return Optional.of(clazz.cast(this.validationStatusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainValidationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> validationEmails;
        private String validationDomain;
        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidation model) {
            this.domainName(model.domainName);
            this.validationEmails(model.validationEmails);
            this.validationDomain(model.validationDomain);
            this.validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getValidationEmails() {
            return this.validationEmails;
        }

        @Override
        public final Builder validationEmails(Collection<String> validationEmails) {
            this.validationEmails = ValidationEmailListCopier.copy(validationEmails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationEmails(String ... validationEmails) {
            this.validationEmails(Arrays.asList(validationEmails));
            return this;
        }

        public final void setValidationEmails(Collection<String> validationEmails) {
            this.validationEmails = ValidationEmailListCopier.copy(validationEmails);
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(DomainStatus validationStatus) {
            this.validationStatus(validationStatus.toString());
            return this;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        public DomainValidation build() {
            return new DomainValidation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainValidation> {
        public Builder domainName(String var1);

        public Builder validationEmails(Collection<String> var1);

        public Builder validationEmails(String ... var1);

        public Builder validationDomain(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(DomainStatus var1);
    }
}

