/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.DomainValidation;

@SdkInternalApi
public class DomainValidationMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<List> VALIDATIONEMAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationEmails").build();
    private static final MarshallingInfo<String> VALIDATIONDOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationDomain").build();
    private static final MarshallingInfo<String> VALIDATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationStatus").build();
    private static final DomainValidationMarshaller INSTANCE = new DomainValidationMarshaller();

    public static DomainValidationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainValidation domainValidation, ProtocolMarshaller protocolMarshaller) {
        if (domainValidation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)domainValidation.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(domainValidation.validationEmails(), VALIDATIONEMAILS_BINDING);
            protocolMarshaller.marshall((Object)domainValidation.validationDomain(), VALIDATIONDOMAIN_BINDING);
            protocolMarshaller.marshall((Object)domainValidation.validationStatusString(), VALIDATIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

