/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.Filters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FiltersMarshaller {
    private static final MarshallingInfo<List> EXTENDEDKEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extendedKeyUsage").isBinary(false).build();
    private static final MarshallingInfo<List> KEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyUsage").isBinary(false).build();
    private static final MarshallingInfo<List> KEYTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyTypes").isBinary(false).build();
    private static final FiltersMarshaller INSTANCE = new FiltersMarshaller();

    private FiltersMarshaller() {
    }

    public static FiltersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Filters filters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)filters, (String)"filters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(filters.extendedKeyUsageAsStrings(), EXTENDEDKEYUSAGE_BINDING);
            protocolMarshaller.marshall(filters.keyUsageAsStrings(), KEYUSAGE_BINDING);
            protocolMarshaller.marshall(filters.keyTypesAsStrings(), KEYTYPES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

