/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.ExportCertificateRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> PASSPHRASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Passphrase").isBinary(false).build();
    private static final ExportCertificateRequestModelMarshaller INSTANCE = new ExportCertificateRequestModelMarshaller();

    private ExportCertificateRequestModelMarshaller() {
    }

    public static ExportCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportCertificateRequest exportCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)exportCertificateRequest), (String)"exportCertificateRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportCertificateRequest.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)exportCertificateRequest.passphrase(), PASSPHRASE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

