/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.services.acm.model.CertificateOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCertificateOptionsRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, UpdateCertificateOptionsRequest> {
    private final String certificateArn;
    private final CertificateOptions options;

    private UpdateCertificateOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.options = builder.options;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public CertificateOptions options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateOptionsRequest)) {
            return false;
        }
        UpdateCertificateOptionsRequest other = (UpdateCertificateOptionsRequest)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCertificateOptionsRequest").add("CertificateArn", (Object)this.certificateArn()).add("Options", (Object)this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String certificateArn;
        private CertificateOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateOptionsRequest model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.options(model.options);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final CertificateOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(CertificateOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(CertificateOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateOptionsRequest build() {
            return new UpdateCertificateOptionsRequest(this);
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    CopyableBuilder<Builder, UpdateCertificateOptionsRequest> {
        public Builder certificateArn(String var1);

        public Builder options(CertificateOptions var1);

        default public Builder options(Consumer<CertificateOptions.Builder> options) {
            return this.options((CertificateOptions)((CertificateOptions.Builder)CertificateOptions.builder().applyMutation(options)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

