/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.KeyUsageName;
import software.amazon.awssdk.services.acm.transform.KeyUsageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyUsage> {
    private final String name;

    private KeyUsage(BuilderImpl builder) {
        this.name = builder.name;
    }

    public KeyUsageName name() {
        return KeyUsageName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsage)) {
            return false;
        }
        KeyUsage other = (KeyUsage)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString());
    }

    public String toString() {
        return ToString.builder((String)"KeyUsage").add("Name", (Object)this.nameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsage model) {
            this.name(model.name);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(KeyUsageName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public KeyUsage build() {
            return new KeyUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyUsage> {
        public Builder name(String var1);

        public Builder name(KeyUsageName var1);
    }
}

