/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName;
import software.amazon.awssdk.services.acm.transform.ExtendedKeyUsageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedKeyUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, ExtendedKeyUsage> {
    private final String name;
    private final String oid;

    private ExtendedKeyUsage(BuilderImpl builder) {
        this.name = builder.name;
        this.oid = builder.oid;
    }

    public ExtendedKeyUsageName name() {
        return ExtendedKeyUsageName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public String oid() {
        return this.oid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedKeyUsage)) {
            return false;
        }
        ExtendedKeyUsage other = (ExtendedKeyUsage)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.oid(), other.oid());
    }

    public String toString() {
        return ToString.builder((String)"ExtendedKeyUsage").add("Name", (Object)this.nameAsString()).add("OID", (Object)this.oid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "OID": {
                return Optional.ofNullable(clazz.cast(this.oid()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtendedKeyUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String oid;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedKeyUsage model) {
            this.name(model.name);
            this.oid(model.oid);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtendedKeyUsageName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOID() {
            return this.oid;
        }

        @Override
        public final Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public final void setOID(String oid) {
            this.oid = oid;
        }

        public ExtendedKeyUsage build() {
            return new ExtendedKeyUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExtendedKeyUsage> {
        public Builder name(String var1);

        public Builder name(ExtendedKeyUsageName var1);

        public Builder oid(String var1);
    }
}

