/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.acm.model.AcmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportCertificateResponse
extends AcmResponse
implements ToCopyableBuilder<Builder, ExportCertificateResponse> {
    private final String certificate;
    private final String certificateChain;
    private final String privateKey;

    private ExportCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
        this.privateKey = builder.privateKey;
    }

    public String certificate() {
        return this.certificate;
    }

    public String certificateChain() {
        return this.certificateChain;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportCertificateResponse)) {
            return false;
        }
        ExportCertificateResponse other = (ExportCertificateResponse)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.privateKey(), other.privateKey());
    }

    public String toString() {
        return ToString.builder((String)"ExportCertificateResponse").add("Certificate", (Object)this.certificate()).add("CertificateChain", (Object)this.certificateChain()).add("PrivateKey", (Object)this.privateKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AcmResponse.BuilderImpl
    implements Builder {
        private String certificate;
        private String certificateChain;
        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportCertificateResponse model) {
            super(model);
            this.certificate(model.certificate);
            this.certificateChain(model.certificateChain);
            this.privateKey(model.privateKey);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public ExportCertificateResponse build() {
            return new ExportCertificateResponse(this);
        }
    }

    public static interface Builder
    extends AcmResponse.Builder,
    CopyableBuilder<Builder, ExportCertificateResponse> {
        public Builder certificate(String var1);

        public Builder certificateChain(String var1);

        public Builder privateKey(String var1);
    }
}

