/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.DomainStatus;
import software.amazon.awssdk.services.acm.model.ResourceRecord;
import software.amazon.awssdk.services.acm.model.ValidationEmailListCopier;
import software.amazon.awssdk.services.acm.model.ValidationMethod;
import software.amazon.awssdk.services.acm.transform.DomainValidationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainValidation
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainValidation> {
    private final String domainName;
    private final List<String> validationEmails;
    private final String validationDomain;
    private final String validationStatus;
    private final ResourceRecord resourceRecord;
    private final String validationMethod;

    private DomainValidation(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationEmails = builder.validationEmails;
        this.validationDomain = builder.validationDomain;
        this.validationStatus = builder.validationStatus;
        this.resourceRecord = builder.resourceRecord;
        this.validationMethod = builder.validationMethod;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> validationEmails() {
        return this.validationEmails;
    }

    public String validationDomain() {
        return this.validationDomain;
    }

    public DomainStatus validationStatus() {
        return DomainStatus.fromValue(this.validationStatus);
    }

    public String validationStatusAsString() {
        return this.validationStatus;
    }

    public ResourceRecord resourceRecord() {
        return this.resourceRecord;
    }

    public ValidationMethod validationMethod() {
        return ValidationMethod.fromValue(this.validationMethod);
    }

    public String validationMethodAsString() {
        return this.validationMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationEmails());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationMethodAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidation)) {
            return false;
        }
        DomainValidation other = (DomainValidation)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.validationEmails(), other.validationEmails()) && Objects.equals(this.validationDomain(), other.validationDomain()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.resourceRecord(), other.resourceRecord()) && Objects.equals(this.validationMethodAsString(), other.validationMethodAsString());
    }

    public String toString() {
        return ToString.builder((String)"DomainValidation").add("DomainName", (Object)this.domainName()).add("ValidationEmails", this.validationEmails()).add("ValidationDomain", (Object)this.validationDomain()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("ResourceRecord", (Object)this.resourceRecord()).add("ValidationMethod", (Object)this.validationMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ValidationEmails": {
                return Optional.ofNullable(clazz.cast(this.validationEmails()));
            }
            case "ValidationDomain": {
                return Optional.ofNullable(clazz.cast(this.validationDomain()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "ResourceRecord": {
                return Optional.ofNullable(clazz.cast(this.resourceRecord()));
            }
            case "ValidationMethod": {
                return Optional.ofNullable(clazz.cast(this.validationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainValidationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> validationEmails = DefaultSdkAutoConstructList.getInstance();
        private String validationDomain;
        private String validationStatus;
        private ResourceRecord resourceRecord;
        private String validationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidation model) {
            this.domainName(model.domainName);
            this.validationEmails(model.validationEmails);
            this.validationDomain(model.validationDomain);
            this.validationStatus(model.validationStatus);
            this.resourceRecord(model.resourceRecord);
            this.validationMethod(model.validationMethod);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getValidationEmails() {
            return this.validationEmails;
        }

        @Override
        public final Builder validationEmails(Collection<String> validationEmails) {
            this.validationEmails = ValidationEmailListCopier.copy(validationEmails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationEmails(String ... validationEmails) {
            this.validationEmails(Arrays.asList(validationEmails));
            return this;
        }

        public final void setValidationEmails(Collection<String> validationEmails) {
            this.validationEmails = ValidationEmailListCopier.copy(validationEmails);
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(DomainStatus validationStatus) {
            this.validationStatus(validationStatus.toString());
            return this;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        public final ResourceRecord.Builder getResourceRecord() {
            return this.resourceRecord != null ? this.resourceRecord.toBuilder() : null;
        }

        @Override
        public final Builder resourceRecord(ResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final void setResourceRecord(ResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        public final String getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        public final Builder validationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        @Override
        public final Builder validationMethod(ValidationMethod validationMethod) {
            this.validationMethod(validationMethod.toString());
            return this;
        }

        public final void setValidationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
        }

        public DomainValidation build() {
            return new DomainValidation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainValidation> {
        public Builder domainName(String var1);

        public Builder validationEmails(Collection<String> var1);

        public Builder validationEmails(String ... var1);

        public Builder validationDomain(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(DomainStatus var1);

        public Builder resourceRecord(ResourceRecord var1);

        default public Builder resourceRecord(Consumer<ResourceRecord.Builder> resourceRecord) {
            return this.resourceRecord((ResourceRecord)((ResourceRecord.Builder)ResourceRecord.builder().applyMutation(resourceRecord)).build());
        }

        public Builder validationMethod(String var1);

        public Builder validationMethod(ValidationMethod var1);
    }
}

