/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListCertificatesRequestModelMarshaller {
    private static final MarshallingInfo<List> CERTIFICATESTATUSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateStatuses").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxItems").isBinary(false).build();
    private static final ListCertificatesRequestModelMarshaller INSTANCE = new ListCertificatesRequestModelMarshaller();

    private ListCertificatesRequestModelMarshaller() {
    }

    public static ListCertificatesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListCertificatesRequest listCertificatesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listCertificatesRequest), (String)"listCertificatesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(listCertificatesRequest.certificateStatusesAsStrings(), CERTIFICATESTATUSES_BINDING);
            protocolMarshaller.marshall((Object)listCertificatesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listCertificatesRequest.maxItems(), MAXITEMS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

