/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.acm.model.GetCertificateRequest;
import software.amazon.awssdk.services.acm.transform.GetCertificateRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetCertificateRequestMarshaller
implements Marshaller<Request<GetCertificateRequest>, GetCertificateRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("CertificateManager.GetCertificate").serviceName("ACM").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetCertificateRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetCertificateRequest> marshall(GetCertificateRequest getCertificateRequest) {
        Validate.paramNotNull((Object)((Object)getCertificateRequest), (String)"getCertificateRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getCertificateRequest);
            protocolMarshaller.startMarshalling();
            GetCertificateRequestModelMarshaller.getInstance().marshall(getCertificateRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

