/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateType;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.FailureReason;
import software.amazon.awssdk.services.acm.model.InUseListCopier;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.RenewalSummary;
import software.amazon.awssdk.services.acm.model.RevocationReason;
import software.amazon.awssdk.services.acm.transform.CertificateDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CertificateDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, CertificateDetail> {
    private final String certificateArn;
    private final String domainName;
    private final List<String> subjectAlternativeNames;
    private final List<DomainValidation> domainValidationOptions;
    private final String serial;
    private final String subject;
    private final String issuer;
    private final Instant createdAt;
    private final Instant issuedAt;
    private final Instant importedAt;
    private final String status;
    private final Instant revokedAt;
    private final String revocationReason;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String keyAlgorithm;
    private final String signatureAlgorithm;
    private final List<String> inUseBy;
    private final String failureReason;
    private final String type;
    private final RenewalSummary renewalSummary;

    private CertificateDetail(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domainName = builder.domainName;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.serial = builder.serial;
        this.subject = builder.subject;
        this.issuer = builder.issuer;
        this.createdAt = builder.createdAt;
        this.issuedAt = builder.issuedAt;
        this.importedAt = builder.importedAt;
        this.status = builder.status;
        this.revokedAt = builder.revokedAt;
        this.revocationReason = builder.revocationReason;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.inUseBy = builder.inUseBy;
        this.failureReason = builder.failureReason;
        this.type = builder.type;
        this.renewalSummary = builder.renewalSummary;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public String serial() {
        return this.serial;
    }

    public String subject() {
        return this.subject;
    }

    public String issuer() {
        return this.issuer;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant issuedAt() {
        return this.issuedAt;
    }

    public Instant importedAt() {
        return this.importedAt;
    }

    public CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant revokedAt() {
        return this.revokedAt;
    }

    public RevocationReason revocationReason() {
        return RevocationReason.fromValue(this.revocationReason);
    }

    public String revocationReasonAsString() {
        return this.revocationReason;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public List<String> inUseBy() {
        return this.inUseBy;
    }

    public FailureReason failureReason() {
        return FailureReason.fromValue(this.failureReason);
    }

    public String failureReasonAsString() {
        return this.failureReason;
    }

    public CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public RenewalSummary renewalSummary() {
        return this.renewalSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectAlternativeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainValidationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.serial());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDetail)) {
            return false;
        }
        CertificateDetail other = (CertificateDetail)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions()) && Objects.equals(this.serial(), other.serial()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.importedAt(), other.importedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.revokedAt(), other.revokedAt()) && Objects.equals(this.revocationReasonAsString(), other.revocationReasonAsString()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(this.inUseBy(), other.inUseBy()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.renewalSummary(), other.renewalSummary());
    }

    public String toString() {
        return ToString.builder((String)"CertificateDetail").add("CertificateArn", (Object)this.certificateArn()).add("DomainName", (Object)this.domainName()).add("SubjectAlternativeNames", this.subjectAlternativeNames()).add("DomainValidationOptions", this.domainValidationOptions()).add("Serial", (Object)this.serial()).add("Subject", (Object)this.subject()).add("Issuer", (Object)this.issuer()).add("CreatedAt", (Object)this.createdAt()).add("IssuedAt", (Object)this.issuedAt()).add("ImportedAt", (Object)this.importedAt()).add("Status", (Object)this.statusAsString()).add("RevokedAt", (Object)this.revokedAt()).add("RevocationReason", (Object)this.revocationReasonAsString()).add("NotBefore", (Object)this.notBefore()).add("NotAfter", (Object)this.notAfter()).add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).add("InUseBy", this.inUseBy()).add("FailureReason", (Object)this.failureReasonAsString()).add("Type", (Object)this.typeAsString()).add("RenewalSummary", (Object)this.renewalSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.of(clazz.cast(this.certificateArn()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "SubjectAlternativeNames": {
                return Optional.of(clazz.cast(this.subjectAlternativeNames()));
            }
            case "DomainValidationOptions": {
                return Optional.of(clazz.cast(this.domainValidationOptions()));
            }
            case "Serial": {
                return Optional.of(clazz.cast(this.serial()));
            }
            case "Subject": {
                return Optional.of(clazz.cast(this.subject()));
            }
            case "Issuer": {
                return Optional.of(clazz.cast(this.issuer()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "IssuedAt": {
                return Optional.of(clazz.cast(this.issuedAt()));
            }
            case "ImportedAt": {
                return Optional.of(clazz.cast(this.importedAt()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "RevokedAt": {
                return Optional.of(clazz.cast(this.revokedAt()));
            }
            case "RevocationReason": {
                return Optional.of(clazz.cast(this.revocationReasonAsString()));
            }
            case "NotBefore": {
                return Optional.of(clazz.cast(this.notBefore()));
            }
            case "NotAfter": {
                return Optional.of(clazz.cast(this.notAfter()));
            }
            case "KeyAlgorithm": {
                return Optional.of(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "SignatureAlgorithm": {
                return Optional.of(clazz.cast(this.signatureAlgorithm()));
            }
            case "InUseBy": {
                return Optional.of(clazz.cast(this.inUseBy()));
            }
            case "FailureReason": {
                return Optional.of(clazz.cast(this.failureReasonAsString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "RenewalSummary": {
                return Optional.of(clazz.cast(this.renewalSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domainName;
        private List<String> subjectAlternativeNames;
        private List<DomainValidation> domainValidationOptions;
        private String serial;
        private String subject;
        private String issuer;
        private Instant createdAt;
        private Instant issuedAt;
        private Instant importedAt;
        private String status;
        private Instant revokedAt;
        private String revocationReason;
        private Instant notBefore;
        private Instant notAfter;
        private String keyAlgorithm;
        private String signatureAlgorithm;
        private List<String> inUseBy;
        private String failureReason;
        private String type;
        private RenewalSummary renewalSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDetail model) {
            this.certificateArn(model.certificateArn);
            this.domainName(model.domainName);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.domainValidationOptions(model.domainValidationOptions);
            this.serial(model.serial);
            this.subject(model.subject);
            this.issuer(model.issuer);
            this.createdAt(model.createdAt);
            this.issuedAt(model.issuedAt);
            this.importedAt(model.importedAt);
            this.status(model.status);
            this.revokedAt(model.revokedAt);
            this.revocationReason(model.revocationReason);
            this.notBefore(model.notBefore);
            this.notAfter(model.notAfter);
            this.keyAlgorithm(model.keyAlgorithm);
            this.signatureAlgorithm(model.signatureAlgorithm);
            this.inUseBy(model.inUseBy);
            this.failureReason(model.failureReason);
            this.type(model.type);
            this.renewalSummary(model.renewalSummary);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
        }

        public final Collection<DomainValidation.Builder> getDomainValidationOptions() {
            return this.domainValidationOptions != null ? (Collection)this.domainValidationOptions.stream().map(DomainValidation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (DomainValidation)((DomainValidation.Builder)DomainValidation.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copyFromBuilder(domainValidationOptions);
        }

        public final String getSerial() {
            return this.serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        public final Instant getImportedAt() {
            return this.importedAt;
        }

        @Override
        public final Builder importedAt(Instant importedAt) {
            this.importedAt = importedAt;
            return this;
        }

        public final void setImportedAt(Instant importedAt) {
            this.importedAt = importedAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getRevokedAt() {
            return this.revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason.toString());
            return this;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm.toString());
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public final Collection<String> getInUseBy() {
            return this.inUseBy;
        }

        @Override
        public final Builder inUseBy(Collection<String> inUseBy) {
            this.inUseBy = InUseListCopier.copy(inUseBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inUseBy(String ... inUseBy) {
            this.inUseBy(Arrays.asList(inUseBy));
            return this;
        }

        public final void setInUseBy(Collection<String> inUseBy) {
            this.inUseBy = InUseListCopier.copy(inUseBy);
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final RenewalSummary.Builder getRenewalSummary() {
            return this.renewalSummary != null ? this.renewalSummary.toBuilder() : null;
        }

        @Override
        public final Builder renewalSummary(RenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final void setRenewalSummary(RenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        public CertificateDetail build() {
            return new CertificateDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CertificateDetail> {
        public Builder certificateArn(String var1);

        public Builder domainName(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);

        public Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... var1);

        public Builder serial(String var1);

        public Builder subject(String var1);

        public Builder issuer(String var1);

        public Builder createdAt(Instant var1);

        public Builder issuedAt(Instant var1);

        public Builder importedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder revokedAt(Instant var1);

        public Builder revocationReason(String var1);

        public Builder revocationReason(RevocationReason var1);

        public Builder notBefore(Instant var1);

        public Builder notAfter(Instant var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder signatureAlgorithm(String var1);

        public Builder inUseBy(Collection<String> var1);

        public Builder inUseBy(String ... var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder renewalSummary(RenewalSummary var1);

        default public Builder renewalSummary(Consumer<RenewalSummary.Builder> renewalSummary) {
            return this.renewalSummary((RenewalSummary)((RenewalSummary.Builder)RenewalSummary.builder().apply(renewalSummary)).build());
        }
    }
}

