/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.RenewalStatus;
import software.amazon.awssdk.services.acm.transform.RenewalSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RenewalSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, RenewalSummary> {
    private final String renewalStatus;
    private final List<DomainValidation> domainValidationOptions;

    private RenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    public String renewalStatus() {
        return this.renewalStatus;
    }

    public List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.renewalStatus() == null ? 0 : this.renewalStatus().hashCode());
        hashCode = 31 * hashCode + (this.domainValidationOptions() == null ? 0 : this.domainValidationOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary)obj;
        if (other.renewalStatus() == null ^ this.renewalStatus() == null) {
            return false;
        }
        if (other.renewalStatus() != null && !other.renewalStatus().equals(this.renewalStatus())) {
            return false;
        }
        if (other.domainValidationOptions() == null ^ this.domainValidationOptions() == null) {
            return false;
        }
        return other.domainValidationOptions() == null || other.domainValidationOptions().equals(this.domainValidationOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.renewalStatus() != null) {
            sb.append("RenewalStatus: ").append(this.renewalStatus()).append(",");
        }
        if (this.domainValidationOptions() != null) {
            sb.append("DomainValidationOptions: ").append(this.domainValidationOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RenewalSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String renewalStatus;
        private List<DomainValidation> domainValidationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSummary model) {
            this.setRenewalStatus(model.renewalStatus);
            this.setDomainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return this.renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final void setRenewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus.toString());
        }

        public final Collection<DomainValidation> getDomainValidationOptions() {
            return this.domainValidationOptions;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            if (this.domainValidationOptions == null) {
                this.domainValidationOptions = new ArrayList<DomainValidation>(domainValidationOptions.length);
            }
            for (DomainValidation e : domainValidationOptions) {
                this.domainValidationOptions.add(e);
            }
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
        }

        @SafeVarargs
        public final void setDomainValidationOptions(DomainValidation ... domainValidationOptions) {
            if (this.domainValidationOptions == null) {
                this.domainValidationOptions = new ArrayList<DomainValidation>(domainValidationOptions.length);
            }
            for (DomainValidation e : domainValidationOptions) {
                this.domainValidationOptions.add(e);
            }
        }

        public RenewalSummary build() {
            return new RenewalSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RenewalSummary> {
        public Builder renewalStatus(String var1);

        public Builder renewalStatus(RenewalStatus var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);
    }
}

