/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountNameRequest extends AccountRequest implements
        ToCopyableBuilder<PutAccountNameRequest.Builder, PutAccountNameRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(PutAccountNameRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(PutAccountNameRequest::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCOUNT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String accountName;

    private PutAccountNameRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accountName = builder.accountName;
    }

    /**
     * <p>
     * Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify
     * with this operation.
     * </p>
     * <p>
     * If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call
     * the operation.
     * </p>
     * <p>
     * To use this parameter, the caller must be an identity in the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >organization's management account</a> or a delegated administrator account, and the specified account ID must be
     * a member account in the same organization. The organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features enabled</a>, and the organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     * access</a> enabled for the Account Management service, and optionally a <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
     * admin</a> account assigned.
     * </p>
     * <note>
     * <p>
     * The management account can't specify its own <code>AccountId</code>; it must call the operation in standalone
     * context by not including the <code>AccountId</code> parameter.
     * </p>
     * </note>
     * <p>
     * To call this operation on an account that is not a member of an organization, then don't specify this parameter,
     * and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.
     * </p>
     * 
     * @return Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or
     *         modify with this operation.</p>
     *         <p>
     *         If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used
     *         to call the operation.
     *         </p>
     *         <p>
     *         To use this parameter, the caller must be an identity in the <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     *         >organization's management account</a> or a delegated administrator account, and the specified account ID
     *         must be a member account in the same organization. The organization must have <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >all features enabled</a>, and the organization must have <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     *         access</a> enabled for the Account Management service, and optionally a <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
     *         >delegated admin</a> account assigned.
     *         </p>
     *         <note>
     *         <p>
     *         The management account can't specify its own <code>AccountId</code>; it must call the operation in
     *         standalone context by not including the <code>AccountId</code> parameter.
     *         </p>
     *         </note>
     *         <p>
     *         To call this operation on an account that is not a member of an organization, then don't specify this
     *         parameter, and call the operation using an identity belonging to the account whose contacts you wish to
     *         retrieve or modify.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the account.
     * </p>
     * 
     * @return The name of the account.
     */
    public final String accountName() {
        return accountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountNameRequest)) {
            return false;
        }
        PutAccountNameRequest other = (PutAccountNameRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(accountName(), other.accountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountNameRequest").add("AccountId", accountId())
                .add("AccountName", accountName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAccountNameRequest, T> g) {
        return obj -> g.apply((PutAccountNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccountRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountNameRequest> {
        /**
         * <p>
         * Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify
         * with this operation.
         * </p>
         * <p>
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to
         * call the operation.
         * </p>
         * <p>
         * To use this parameter, the caller must be an identity in the <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         * >organization's management account</a> or a delegated administrator account, and the specified account ID
         * must be a member account in the same organization. The organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         * >all features enabled</a>, and the organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
         * access</a> enabled for the Account Management service, and optionally a <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
         * admin</a> account assigned.
         * </p>
         * <note>
         * <p>
         * The management account can't specify its own <code>AccountId</code>; it must call the operation in standalone
         * context by not including the <code>AccountId</code> parameter.
         * </p>
         * </note>
         * <p>
         * To call this operation on an account that is not a member of an organization, then don't specify this
         * parameter, and call the operation using an identity belonging to the account whose contacts you wish to
         * retrieve or modify.
         * </p>
         * 
         * @param accountId
         *        Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or
         *        modify with this operation.</p>
         *        <p>
         *        If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity
         *        used to call the operation.
         *        </p>
         *        <p>
         *        To use this parameter, the caller must be an identity in the <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         *        >organization's management account</a> or a delegated administrator account, and the specified account
         *        ID must be a member account in the same organization. The organization must have <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         *        >all features enabled</a>, and the organization must have <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html"
         *        >trusted access</a> enabled for the Account Management service, and optionally a <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
         *        >delegated admin</a> account assigned.
         *        </p>
         *        <note>
         *        <p>
         *        The management account can't specify its own <code>AccountId</code>; it must call the operation in
         *        standalone context by not including the <code>AccountId</code> parameter.
         *        </p>
         *        </note>
         *        <p>
         *        To call this operation on an account that is not a member of an organization, then don't specify this
         *        parameter, and call the operation using an identity belonging to the account whose contacts you wish
         *        to retrieve or modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the account.
         * </p>
         * 
         * @param accountName
         *        The name of the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccountRequest.BuilderImpl implements Builder {
        private String accountId;

        private String accountName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountNameRequest model) {
            super(model);
            accountId(model.accountId);
            accountName(model.accountName);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountNameRequest build() {
            return new PutAccountNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
