/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegionsResponse extends AccountResponse implements
        ToCopyableBuilder<ListRegionsResponse.Builder, ListRegionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Region>> REGIONS_FIELD = SdkField
            .<List<Region>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(ListRegionsResponse::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Region> builder(MarshallingType.SDK_POJO)
                                            .constructor(Region::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Region> regions;

    private ListRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.regions = builder.regions;
    }

    /**
     * <p>
     * If there is more data to be returned, this will be populated. It should be passed into the
     * <code>next-token</code> request parameter of <code>list-regions</code>.
     * </p>
     * 
     * @return If there is more data to be returned, this will be populated. It should be passed into the
     *         <code>next-token</code> request parameter of <code>list-regions</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a list of Regions for a given account, or if the filtered parameter was used, a list of Regions that
     * match the filter criteria set in the <code>filter</code> parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return This is a list of Regions for a given account, or if the filtered parameter was used, a list of Regions
     *         that match the filter criteria set in the <code>filter</code> parameter.
     */
    public final List<Region> regions() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegionsResponse)) {
            return false;
        }
        ListRegionsResponse other = (ListRegionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRegionsResponse").add("NextToken", nextToken())
                .add("Regions", hasRegions() ? regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegionsResponse, T> g) {
        return obj -> g.apply((ListRegionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccountResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRegionsResponse> {
        /**
         * <p>
         * If there is more data to be returned, this will be populated. It should be passed into the
         * <code>next-token</code> request parameter of <code>list-regions</code>.
         * </p>
         * 
         * @param nextToken
         *        If there is more data to be returned, this will be populated. It should be passed into the
         *        <code>next-token</code> request parameter of <code>list-regions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * This is a list of Regions for a given account, or if the filtered parameter was used, a list of Regions that
         * match the filter criteria set in the <code>filter</code> parameter.
         * </p>
         * 
         * @param regions
         *        This is a list of Regions for a given account, or if the filtered parameter was used, a list of
         *        Regions that match the filter criteria set in the <code>filter</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<Region> regions);

        /**
         * <p>
         * This is a list of Regions for a given account, or if the filtered parameter was used, a list of Regions that
         * match the filter criteria set in the <code>filter</code> parameter.
         * </p>
         * 
         * @param regions
         *        This is a list of Regions for a given account, or if the filtered parameter was used, a list of
         *        Regions that match the filter criteria set in the <code>filter</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Region... regions);

        /**
         * <p>
         * This is a list of Regions for a given account, or if the filtered parameter was used, a list of Regions that
         * match the filter criteria set in the <code>filter</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.account.model.Region.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.account.model.Region#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.account.model.Region.Builder#build()} is called immediately and its
         * result is passed to {@link #regions(List<Region>)}.
         * 
         * @param regions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.account.model.Region.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regions(java.util.Collection<Region>)
         */
        Builder regions(Consumer<Region.Builder>... regions);
    }

    static final class BuilderImpl extends AccountResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Region> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            regions(model.regions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Region.Builder> getRegions() {
            List<Region.Builder> result = RegionOptListCopier.copyToBuilder(this.regions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionOptListCopier.copyFromBuilder(regions);
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionOptListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<Region.Builder>... regions) {
            regions(Stream.of(regions).map(c -> Region.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegionsResponse build() {
            return new ListRegionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
