/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountInformationResponse extends AccountResponse implements
        ToCopyableBuilder<GetAccountInformationResponse.Builder, GetAccountInformationResponse> {
    private static final SdkField<Instant> ACCOUNT_CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AccountCreatedDate")
            .getter(getter(GetAccountInformationResponse::accountCreatedDate))
            .setter(setter(Builder::accountCreatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountCreatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(GetAccountInformationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(GetAccountInformationResponse::accountName))
            .setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_CREATED_DATE_FIELD,
            ACCOUNT_ID_FIELD, ACCOUNT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant accountCreatedDate;

    private final String accountId;

    private final String accountName;

    private GetAccountInformationResponse(BuilderImpl builder) {
        super(builder);
        this.accountCreatedDate = builder.accountCreatedDate;
        this.accountId = builder.accountId;
        this.accountName = builder.accountName;
    }

    /**
     * <p>
     * The date and time the account was created.
     * </p>
     * 
     * @return The date and time the account was created.
     */
    public final Instant accountCreatedDate() {
        return accountCreatedDate;
    }

    /**
     * <p>
     * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify
     * with this operation. To use this parameter, the caller must be an identity in the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >organization's management account</a> or a delegated administrator account. The specified account ID must be a
     * member account in the same organization. The organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features enabled</a>, and the organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">trusted access</a>
     * enabled for the Account Management service, and optionally a <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#delegated-admin"
     * >delegated admin</a> account assigned.
     * </p>
     * <p>
     * This operation can only be called from the management account or the delegated administrator account of an
     * organization for a member account.
     * </p>
     * <note>
     * <p>
     * The management account can't specify its own <code>AccountId</code>.
     * </p>
     * </note>
     * 
     * @return Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or
     *         modify with this operation. To use this parameter, the caller must be an identity in the <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     *         >organization's management account</a> or a delegated administrator account. The specified account ID
     *         must be a member account in the same organization. The organization must have <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >all features enabled</a>, and the organization must have <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">trusted
     *         access</a> enabled for the Account Management service, and optionally a <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#delegated-admin"
     *         >delegated admin</a> account assigned.</p>
     *         <p>
     *         This operation can only be called from the management account or the delegated administrator account of
     *         an organization for a member account.
     *         </p>
     *         <note>
     *         <p>
     *         The management account can't specify its own <code>AccountId</code>.
     *         </p>
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the account.
     * </p>
     * 
     * @return The name of the account.
     */
    public final String accountName() {
        return accountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountInformationResponse)) {
            return false;
        }
        GetAccountInformationResponse other = (GetAccountInformationResponse) obj;
        return Objects.equals(accountCreatedDate(), other.accountCreatedDate()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(accountName(), other.accountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountInformationResponse").add("AccountCreatedDate", accountCreatedDate())
                .add("AccountId", accountId())
                .add("AccountName", accountName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountCreatedDate":
            return Optional.ofNullable(clazz.cast(accountCreatedDate()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountCreatedDate", ACCOUNT_CREATED_DATE_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountInformationResponse, T> g) {
        return obj -> g.apply((GetAccountInformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccountResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountInformationResponse> {
        /**
         * <p>
         * The date and time the account was created.
         * </p>
         * 
         * @param accountCreatedDate
         *        The date and time the account was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountCreatedDate(Instant accountCreatedDate);

        /**
         * <p>
         * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify
         * with this operation. To use this parameter, the caller must be an identity in the <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         * >organization's management account</a> or a delegated administrator account. The specified account ID must be
         * a member account in the same organization. The organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         * >all features enabled</a>, and the organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">trusted
         * access</a> enabled for the Account Management service, and optionally a <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#delegated-admin"
         * >delegated admin</a> account assigned.
         * </p>
         * <p>
         * This operation can only be called from the management account or the delegated administrator account of an
         * organization for a member account.
         * </p>
         * <note>
         * <p>
         * The management account can't specify its own <code>AccountId</code>.
         * </p>
         * </note>
         * 
         * @param accountId
         *        Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or
         *        modify with this operation. To use this parameter, the caller must be an identity in the <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         *        >organization's management account</a> or a delegated administrator account. The specified account ID
         *        must be a member account in the same organization. The organization must have <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         *        >all features enabled</a>, and the organization must have <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">trusted
         *        access</a> enabled for the Account Management service, and optionally a <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#delegated-admin"
         *        >delegated admin</a> account assigned.</p>
         *        <p>
         *        This operation can only be called from the management account or the delegated administrator account
         *        of an organization for a member account.
         *        </p>
         *        <note>
         *        <p>
         *        The management account can't specify its own <code>AccountId</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the account.
         * </p>
         * 
         * @param accountName
         *        The name of the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);
    }

    static final class BuilderImpl extends AccountResponse.BuilderImpl implements Builder {
        private Instant accountCreatedDate;

        private String accountId;

        private String accountName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountInformationResponse model) {
            super(model);
            accountCreatedDate(model.accountCreatedDate);
            accountId(model.accountId);
            accountName(model.accountName);
        }

        public final Instant getAccountCreatedDate() {
            return accountCreatedDate;
        }

        public final void setAccountCreatedDate(Instant accountCreatedDate) {
            this.accountCreatedDate = accountCreatedDate;
        }

        @Override
        public final Builder accountCreatedDate(Instant accountCreatedDate) {
            this.accountCreatedDate = accountCreatedDate;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public GetAccountInformationResponse build() {
            return new GetAccountInformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
