/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.AccountRequest;
import software.amazon.awssdk.services.account.model.AlternateContactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAlternateContactRequest
extends AccountRequest
implements ToCopyableBuilder<Builder, DeleteAlternateContactRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DeleteAlternateContactRequest.getter(DeleteAlternateContactRequest::accountId)).setter(DeleteAlternateContactRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ALTERNATE_CONTACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternateContactType").getter(DeleteAlternateContactRequest.getter(DeleteAlternateContactRequest::alternateContactTypeAsString)).setter(DeleteAlternateContactRequest.setter(Builder::alternateContactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateContactType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ALTERNATE_CONTACT_TYPE_FIELD));
    private final String accountId;
    private final String alternateContactType;

    private DeleteAlternateContactRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.alternateContactType = builder.alternateContactType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AlternateContactType alternateContactType() {
        return AlternateContactType.fromValue(this.alternateContactType);
    }

    public final String alternateContactTypeAsString() {
        return this.alternateContactType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateContactTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAlternateContactRequest)) {
            return false;
        }
        DeleteAlternateContactRequest other = (DeleteAlternateContactRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.alternateContactTypeAsString(), other.alternateContactTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAlternateContactRequest").add("AccountId", (Object)this.accountId()).add("AlternateContactType", (Object)this.alternateContactTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AlternateContactType": {
                return Optional.ofNullable(clazz.cast(this.alternateContactTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAlternateContactRequest, T> g) {
        return obj -> g.apply((DeleteAlternateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String alternateContactType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAlternateContactRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.alternateContactType(model.alternateContactType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAlternateContactType() {
            return this.alternateContactType;
        }

        public final void setAlternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
        }

        @Override
        public final Builder alternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
            return this;
        }

        @Override
        public final Builder alternateContactType(AlternateContactType alternateContactType) {
            this.alternateContactType(alternateContactType == null ? null : alternateContactType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAlternateContactRequest build() {
            return new DeleteAlternateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAlternateContactRequest> {
        public Builder accountId(String var1);

        public Builder alternateContactType(String var1);

        public Builder alternateContactType(AlternateContactType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

