/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.account.AccountClient;
import software.amazon.awssdk.services.account.AccountClientBuilder;
import software.amazon.awssdk.services.account.AccountServiceClientConfiguration;
import software.amazon.awssdk.services.account.DefaultAccountBaseClientBuilder;
import software.amazon.awssdk.services.account.DefaultAccountClient;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointProvider;

@SdkInternalApi
final class DefaultAccountClientBuilder
extends DefaultAccountBaseClientBuilder<AccountClientBuilder, AccountClient>
implements AccountClientBuilder {
    DefaultAccountClientBuilder() {
    }

    @Override
    public DefaultAccountClientBuilder endpointProvider(AccountEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AccountClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAccountClientBuilder.validateClientOptions(clientConfiguration);
        AccountServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAccountClient client = new DefaultAccountClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AccountServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AccountServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

