/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ActionListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ConditionKeyMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSource;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSourceListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.InternalAccessType;
import software.amazon.awssdk.services.accessanalyzer.model.PrincipalMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.PrincipalType;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceControlPolicyRestriction;
import software.amazon.awssdk.services.accessanalyzer.model.ServiceControlPolicyRestriction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternalAccessDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InternalAccessDetails> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("action").getter(InternalAccessDetails.getter(InternalAccessDetails::action)).setter(InternalAccessDetails.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("condition").getter(InternalAccessDetails.getter(InternalAccessDetails::condition)).setter(InternalAccessDetails.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("principal").getter(InternalAccessDetails.getter(InternalAccessDetails::principal)).setter(InternalAccessDetails.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PRINCIPAL_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalOwnerAccount").getter(InternalAccessDetails.getter(InternalAccessDetails::principalOwnerAccount)).setter(InternalAccessDetails.setter(Builder::principalOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalOwnerAccount").build()}).build();
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessType").getter(InternalAccessDetails.getter(InternalAccessDetails::accessTypeAsString)).setter(InternalAccessDetails.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessType").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalType").getter(InternalAccessDetails.getter(InternalAccessDetails::principalTypeAsString)).setter(InternalAccessDetails.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalType").build()}).build();
    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(InternalAccessDetails.getter(InternalAccessDetails::sources)).setter(InternalAccessDetails.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceControlPolicyRestriction").getter(InternalAccessDetails.getter(InternalAccessDetails::resourceControlPolicyRestrictionAsString)).setter(InternalAccessDetails.setter(Builder::resourceControlPolicyRestriction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceControlPolicyRestriction").build()}).build();
    private static final SdkField<String> SERVICE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceControlPolicyRestriction").getter(InternalAccessDetails.getter(InternalAccessDetails::serviceControlPolicyRestrictionAsString)).setter(InternalAccessDetails.setter(Builder::serviceControlPolicyRestriction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceControlPolicyRestriction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CONDITION_FIELD, PRINCIPAL_FIELD, PRINCIPAL_OWNER_ACCOUNT_FIELD, ACCESS_TYPE_FIELD, PRINCIPAL_TYPE_FIELD, SOURCES_FIELD, RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD, SERVICE_CONTROL_POLICY_RESTRICTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InternalAccessDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> action;
    private final Map<String, String> condition;
    private final Map<String, String> principal;
    private final String principalOwnerAccount;
    private final String accessType;
    private final String principalType;
    private final List<FindingSource> sources;
    private final String resourceControlPolicyRestriction;
    private final String serviceControlPolicyRestriction;

    private InternalAccessDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.condition = builder.condition;
        this.principal = builder.principal;
        this.principalOwnerAccount = builder.principalOwnerAccount;
        this.accessType = builder.accessType;
        this.principalType = builder.principalType;
        this.sources = builder.sources;
        this.resourceControlPolicyRestriction = builder.resourceControlPolicyRestriction;
        this.serviceControlPolicyRestriction = builder.serviceControlPolicyRestriction;
    }

    public final boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public final List<String> action() {
        return this.action;
    }

    public final boolean hasCondition() {
        return this.condition != null && !(this.condition instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> condition() {
        return this.condition;
    }

    public final boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> principal() {
        return this.principal;
    }

    public final String principalOwnerAccount() {
        return this.principalOwnerAccount;
    }

    public final InternalAccessType accessType() {
        return InternalAccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<FindingSource> sources() {
        return this.sources;
    }

    public final ResourceControlPolicyRestriction resourceControlPolicyRestriction() {
        return ResourceControlPolicyRestriction.fromValue(this.resourceControlPolicyRestriction);
    }

    public final String resourceControlPolicyRestrictionAsString() {
        return this.resourceControlPolicyRestriction;
    }

    public final ServiceControlPolicyRestriction serviceControlPolicyRestriction() {
        return ServiceControlPolicyRestriction.fromValue(this.serviceControlPolicyRestriction);
    }

    public final String serviceControlPolicyRestrictionAsString() {
        return this.serviceControlPolicyRestriction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAction() ? this.action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCondition() ? this.condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipal() ? this.principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.principalOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceControlPolicyRestrictionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceControlPolicyRestrictionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessDetails)) {
            return false;
        }
        InternalAccessDetails other = (InternalAccessDetails)obj;
        return this.hasAction() == other.hasAction() && Objects.equals(this.action(), other.action()) && this.hasCondition() == other.hasCondition() && Objects.equals(this.condition(), other.condition()) && this.hasPrincipal() == other.hasPrincipal() && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.principalOwnerAccount(), other.principalOwnerAccount()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.resourceControlPolicyRestrictionAsString(), other.resourceControlPolicyRestrictionAsString()) && Objects.equals(this.serviceControlPolicyRestrictionAsString(), other.serviceControlPolicyRestrictionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InternalAccessDetails").add("Action", this.hasAction() ? this.action() : null).add("Condition", this.hasCondition() ? this.condition() : null).add("Principal", this.hasPrincipal() ? this.principal() : null).add("PrincipalOwnerAccount", (Object)this.principalOwnerAccount()).add("AccessType", (Object)this.accessTypeAsString()).add("PrincipalType", (Object)this.principalTypeAsString()).add("Sources", this.hasSources() ? this.sources() : null).add("ResourceControlPolicyRestriction", (Object)this.resourceControlPolicyRestrictionAsString()).add("ServiceControlPolicyRestriction", (Object)this.serviceControlPolicyRestrictionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "principalOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.principalOwnerAccount()));
            }
            case "accessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "principalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "resourceControlPolicyRestriction": {
                return Optional.ofNullable(clazz.cast(this.resourceControlPolicyRestrictionAsString()));
            }
            case "serviceControlPolicyRestriction": {
                return Optional.ofNullable(clazz.cast(this.serviceControlPolicyRestrictionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("principalOwnerAccount", PRINCIPAL_OWNER_ACCOUNT_FIELD);
        map.put("accessType", ACCESS_TYPE_FIELD);
        map.put("principalType", PRINCIPAL_TYPE_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("resourceControlPolicyRestriction", RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD);
        map.put("serviceControlPolicyRestriction", SERVICE_CONTROL_POLICY_RESTRICTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessDetails, T> g) {
        return obj -> g.apply((InternalAccessDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();
        private String principalOwnerAccount;
        private String accessType;
        private String principalType;
        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String resourceControlPolicyRestriction;
        private String serviceControlPolicyRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessDetails model) {
            this.action(model.action);
            this.condition(model.condition);
            this.principal(model.principal);
            this.principalOwnerAccount(model.principalOwnerAccount);
            this.accessType(model.accessType);
            this.principalType(model.principalType);
            this.sources(model.sources);
            this.resourceControlPolicyRestriction(model.resourceControlPolicyRestriction);
            this.serviceControlPolicyRestriction(model.serviceControlPolicyRestriction);
        }

        public final Collection<String> getAction() {
            if (this.action instanceof SdkAutoConstructList) {
                return null;
            }
            return this.action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final Map<String, String> getCondition() {
            if (this.condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (this.principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final String getPrincipalOwnerAccount() {
            return this.principalOwnerAccount;
        }

        public final void setPrincipalOwnerAccount(String principalOwnerAccount) {
            this.principalOwnerAccount = principalOwnerAccount;
        }

        @Override
        public final Builder principalOwnerAccount(String principalOwnerAccount) {
            this.principalOwnerAccount = principalOwnerAccount;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(InternalAccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (FindingSource)((FindingSource.Builder)FindingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceControlPolicyRestriction() {
            return this.resourceControlPolicyRestriction;
        }

        public final void setResourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction(resourceControlPolicyRestriction == null ? null : resourceControlPolicyRestriction.toString());
            return this;
        }

        public final String getServiceControlPolicyRestriction() {
            return this.serviceControlPolicyRestriction;
        }

        public final void setServiceControlPolicyRestriction(String serviceControlPolicyRestriction) {
            this.serviceControlPolicyRestriction = serviceControlPolicyRestriction;
        }

        @Override
        public final Builder serviceControlPolicyRestriction(String serviceControlPolicyRestriction) {
            this.serviceControlPolicyRestriction = serviceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder serviceControlPolicyRestriction(ServiceControlPolicyRestriction serviceControlPolicyRestriction) {
            this.serviceControlPolicyRestriction(serviceControlPolicyRestriction == null ? null : serviceControlPolicyRestriction.toString());
            return this;
        }

        public InternalAccessDetails build() {
            return new InternalAccessDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternalAccessDetails> {
        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder condition(Map<String, String> var1);

        public Builder principal(Map<String, String> var1);

        public Builder principalOwnerAccount(String var1);

        public Builder accessType(String var1);

        public Builder accessType(InternalAccessType var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder sources(Collection<FindingSource> var1);

        public Builder sources(FindingSource ... var1);

        public Builder sources(Consumer<FindingSource.Builder> ... var1);

        public Builder resourceControlPolicyRestriction(String var1);

        public Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction var1);

        public Builder serviceControlPolicyRestriction(String var1);

        public Builder serviceControlPolicyRestriction(ServiceControlPolicyRestriction var1);
    }
}

