/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an unused access finding for an IAM role. IAM Access Analyzer charges for unused access
 * analysis based on the number of IAM roles and users analyzed per month. For more details on pricing, see <a
 * href="https://aws.amazon.com/iam/access-analyzer/pricing">IAM Access Analyzer pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedIamRoleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UnusedIamRoleDetails.Builder, UnusedIamRoleDetails> {
    private static final SdkField<Instant> LAST_ACCESSED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAccessed")
            .getter(getter(UnusedIamRoleDetails::lastAccessed))
            .setter(setter(Builder::lastAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccessed").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_ACCESSED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastAccessed;

    private UnusedIamRoleDetails(BuilderImpl builder) {
        this.lastAccessed = builder.lastAccessed;
    }

    /**
     * <p>
     * The time at which the role was last accessed.
     * </p>
     * 
     * @return The time at which the role was last accessed.
     */
    public final Instant lastAccessed() {
        return lastAccessed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedIamRoleDetails)) {
            return false;
        }
        UnusedIamRoleDetails other = (UnusedIamRoleDetails) obj;
        return Objects.equals(lastAccessed(), other.lastAccessed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedIamRoleDetails").add("LastAccessed", lastAccessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastAccessed":
            return Optional.ofNullable(clazz.cast(lastAccessed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastAccessed", LAST_ACCESSED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnusedIamRoleDetails, T> g) {
        return obj -> g.apply((UnusedIamRoleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedIamRoleDetails> {
        /**
         * <p>
         * The time at which the role was last accessed.
         * </p>
         * 
         * @param lastAccessed
         *        The time at which the role was last accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessed(Instant lastAccessed);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastAccessed;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedIamRoleDetails model) {
            lastAccessed(model.lastAccessed);
        }

        public final Instant getLastAccessed() {
            return lastAccessed;
        }

        public final void setLastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public final Builder lastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        @Override
        public UnusedIamRoleDetails build() {
            return new UnusedIamRoleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
