/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria for an analysis rule for an internal access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternalAccessAnalysisRuleCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<InternalAccessAnalysisRuleCriteria.Builder, InternalAccessAnalysisRuleCriteria> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(InternalAccessAnalysisRuleCriteria::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceTypes")
            .getter(getter(InternalAccessAnalysisRuleCriteria::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceArns")
            .getter(getter(InternalAccessAnalysisRuleCriteria::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            RESOURCE_TYPES_FIELD, RESOURCE_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accountIds;

    private final List<String> resourceTypes;

    private final List<String> resourceArns;

    private InternalAccessAnalysisRuleCriteria(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.resourceTypes = builder.resourceTypes;
        this.resourceArns = builder.resourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services account IDs to apply to the internal access analysis rule criteria. Account IDs can
     * only be applied to the analysis rule criteria for organization-level analyzers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return A list of Amazon Web Services account IDs to apply to the internal access analysis rule criteria. Account
     *         IDs can only be applied to the analysis rule criteria for organization-level analyzers.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only generate
     * findings for resources of these types. These resource types are currently supported for internal access
     * analyzers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::S3::Bucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBSnapshot</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBClusterSnapshot</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3Express::DirectoryBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Stream</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only
     *         generate findings for resources of these types. These resource types are currently supported for internal
     *         access analyzers:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::S3::Bucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBSnapshot</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBClusterSnapshot</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3Express::DirectoryBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Stream</code>
     *         </p>
     *         </li>
     */
    public final List<ResourceType> resourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only generate
     * findings for resources of these types. These resource types are currently supported for internal access
     * analyzers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::S3::Bucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBSnapshot</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBClusterSnapshot</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3Express::DirectoryBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Stream</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only
     *         generate findings for resources of these types. These resource types are currently supported for internal
     *         access analyzers:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::S3::Bucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBSnapshot</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBClusterSnapshot</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3Express::DirectoryBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Stream</code>
     *         </p>
     *         </li>
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource ARNs to apply to the internal access analysis rule criteria. The analyzer will only generate
     * findings for resources that match these ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return A list of resource ARNs to apply to the internal access analysis rule criteria. The analyzer will only
     *         generate findings for resources that match these ARNs.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessAnalysisRuleCriteria)) {
            return false;
        }
        InternalAccessAnalysisRuleCriteria other = (InternalAccessAnalysisRuleCriteria) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings())
                && hasResourceArns() == other.hasResourceArns() && Objects.equals(resourceArns(), other.resourceArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InternalAccessAnalysisRuleCriteria").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null)
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "resourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("resourceTypes", RESOURCE_TYPES_FIELD);
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessAnalysisRuleCriteria, T> g) {
        return obj -> g.apply((InternalAccessAnalysisRuleCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternalAccessAnalysisRuleCriteria> {
        /**
         * <p>
         * A list of Amazon Web Services account IDs to apply to the internal access analysis rule criteria. Account IDs
         * can only be applied to the analysis rule criteria for organization-level analyzers.
         * </p>
         * 
         * @param accountIds
         *        A list of Amazon Web Services account IDs to apply to the internal access analysis rule criteria.
         *        Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * A list of Amazon Web Services account IDs to apply to the internal access analysis rule criteria. Account IDs
         * can only be applied to the analysis rule criteria for organization-level analyzers.
         * </p>
         * 
         * @param accountIds
         *        A list of Amazon Web Services account IDs to apply to the internal access analysis rule criteria.
         *        Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only
         * generate findings for resources of these types. These resource types are currently supported for internal
         * access analyzers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::S3::Bucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBClusterSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3Express::DirectoryBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Stream</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        A list of resource types to apply to the internal access analysis rule criteria. The analyzer will
         *        only generate findings for resources of these types. These resource types are currently supported for
         *        internal access analyzers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Bucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBClusterSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3Express::DirectoryBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Stream</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only
         * generate findings for resources of these types. These resource types are currently supported for internal
         * access analyzers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::S3::Bucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBClusterSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3Express::DirectoryBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Stream</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        A list of resource types to apply to the internal access analysis rule criteria. The analyzer will
         *        only generate findings for resources of these types. These resource types are currently supported for
         *        internal access analyzers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Bucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBClusterSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3Express::DirectoryBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Stream</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only
         * generate findings for resources of these types. These resource types are currently supported for internal
         * access analyzers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::S3::Bucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBClusterSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3Express::DirectoryBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Stream</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        A list of resource types to apply to the internal access analysis rule criteria. The analyzer will
         *        only generate findings for resources of these types. These resource types are currently supported for
         *        internal access analyzers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Bucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBClusterSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3Express::DirectoryBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Stream</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceType> resourceTypes);

        /**
         * <p>
         * A list of resource types to apply to the internal access analysis rule criteria. The analyzer will only
         * generate findings for resources of these types. These resource types are currently supported for internal
         * access analyzers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::S3::Bucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBClusterSnapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3Express::DirectoryBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Stream</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        A list of resource types to apply to the internal access analysis rule criteria. The analyzer will
         *        only generate findings for resources of these types. These resource types are currently supported for
         *        internal access analyzers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Bucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBClusterSnapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3Express::DirectoryBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Stream</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceType... resourceTypes);

        /**
         * <p>
         * A list of resource ARNs to apply to the internal access analysis rule criteria. The analyzer will only
         * generate findings for resources that match these ARNs.
         * </p>
         * 
         * @param resourceArns
         *        A list of resource ARNs to apply to the internal access analysis rule criteria. The analyzer will only
         *        generate findings for resources that match these ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * A list of resource ARNs to apply to the internal access analysis rule criteria. The analyzer will only
         * generate findings for resources that match these ARNs.
         * </p>
         * 
         * @param resourceArns
         *        A list of resource ARNs to apply to the internal access analysis rule criteria. The analyzer will only
         *        generate findings for resources that match these ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessAnalysisRuleCriteria model) {
            accountIds(model.accountIds);
            resourceTypesWithStrings(model.resourceTypes);
            resourceArns(model.resourceArns);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        @Override
        public InternalAccessAnalysisRuleCriteria build() {
            return new InternalAccessAnalysisRuleCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
