/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed access control configuration for a DynamoDB table or index. You can propose a configuration for a new
 * DynamoDB table or index or an existing DynamoDB table or index that you own by specifying the policy for the DynamoDB
 * table or index. For more information, see <a
 * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutResourcePolicy.html"
 * >PutResourcePolicy</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If the configuration is for an existing DynamoDB table or index and you do not specify the DynamoDB policy, then the
 * access preview uses the existing DynamoDB policy for the table or index.
 * </p>
 * </li>
 * <li>
 * <p>
 * If the access preview is for a new resource and you do not specify the policy, then the access preview assumes a
 * DynamoDB table without a policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * To propose deletion of an existing DynamoDB table or index policy, you can specify an empty string for the DynamoDB
 * policy.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamodbTableConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamodbTableConfiguration.Builder, DynamodbTableConfiguration> {
    private static final SdkField<String> TABLE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tablePolicy").getter(getter(DynamodbTableConfiguration::tablePolicy))
            .setter(setter(Builder::tablePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tablePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tablePolicy;

    private DynamodbTableConfiguration(BuilderImpl builder) {
        this.tablePolicy = builder.tablePolicy;
    }

    /**
     * <p>
     * The proposed resource policy defining who can access or manage the DynamoDB table.
     * </p>
     * 
     * @return The proposed resource policy defining who can access or manage the DynamoDB table.
     */
    public final String tablePolicy() {
        return tablePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tablePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamodbTableConfiguration)) {
            return false;
        }
        DynamodbTableConfiguration other = (DynamodbTableConfiguration) obj;
        return Objects.equals(tablePolicy(), other.tablePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamodbTableConfiguration").add("TablePolicy", tablePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tablePolicy":
            return Optional.ofNullable(clazz.cast(tablePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tablePolicy", TABLE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamodbTableConfiguration, T> g) {
        return obj -> g.apply((DynamodbTableConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamodbTableConfiguration> {
        /**
         * <p>
         * The proposed resource policy defining who can access or manage the DynamoDB table.
         * </p>
         * 
         * @param tablePolicy
         *        The proposed resource policy defining who can access or manage the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePolicy(String tablePolicy);
    }

    static final class BuilderImpl implements Builder {
        private String tablePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamodbTableConfiguration model) {
            tablePolicy(model.tablePolicy);
        }

        public final String getTablePolicy() {
            return tablePolicy;
        }

        public final void setTablePolicy(String tablePolicy) {
            this.tablePolicy = tablePolicy;
        }

        @Override
        public final Builder tablePolicy(String tablePolicy) {
            this.tablePolicy = tablePolicy;
            return this;
        }

        @Override
        public DynamodbTableConfiguration build() {
            return new DynamodbTableConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
