/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceControlPolicyRestriction {
    APPLICABLE("APPLICABLE"),
    FAILED_TO_EVALUATE_RCP("FAILED_TO_EVALUATE_RCP"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    APPLIED("APPLIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceControlPolicyRestriction> VALUE_MAP;
    private final String value;

    private ResourceControlPolicyRestriction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceControlPolicyRestriction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceControlPolicyRestriction> knownValues() {
        EnumSet<ResourceControlPolicyRestriction> knownValues = EnumSet.allOf(ResourceControlPolicyRestriction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceControlPolicyRestriction.class, ResourceControlPolicyRestriction::toString);
    }
}

