/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyGeneration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyGeneration> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(PolicyGeneration.getter(PolicyGeneration::jobId)).setter(PolicyGeneration.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(PolicyGeneration.getter(PolicyGeneration::principalArn)).setter(PolicyGeneration.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PolicyGeneration.getter(PolicyGeneration::statusAsString)).setter(PolicyGeneration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedOn").getter(PolicyGeneration.getter(PolicyGeneration::startedOn)).setter(PolicyGeneration.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedOn").getter(PolicyGeneration.getter(PolicyGeneration::completedOn)).setter(PolicyGeneration.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, PRINCIPAL_ARN_FIELD, STATUS_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyGeneration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String principalArn;
    private final String status;
    private final Instant startedOn;
    private final Instant completedOn;

    private PolicyGeneration(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.principalArn = builder.principalArn;
        this.status = builder.status;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGeneration)) {
            return false;
        }
        PolicyGeneration other = (PolicyGeneration)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyGeneration").add("JobId", (Object)this.jobId()).add("PrincipalArn", (Object)this.principalArn()).add("Status", (Object)this.statusAsString()).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "completedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startedOn", STARTED_ON_FIELD);
        map.put("completedOn", COMPLETED_ON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyGeneration, T> g) {
        return obj -> g.apply((PolicyGeneration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String principalArn;
        private String status;
        private Instant startedOn;
        private Instant completedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGeneration model) {
            this.jobId(model.jobId);
            this.principalArn(model.principalArn);
            this.status(model.status);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public PolicyGeneration build() {
            return new PolicyGeneration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyGeneration> {
        public Builder jobId(String var1);

        public Builder principalArn(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder startedOn(Instant var1);

        public Builder completedOn(Instant var1);
    }
}

