/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessCheckResourceType {
    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),
    AWS_DYNAMO_DB_STREAM("AWS::DynamoDB::Stream"),
    AWS_EFS_FILE_SYSTEM("AWS::EFS::FileSystem"),
    AWS_OPEN_SEARCH_SERVICE_DOMAIN("AWS::OpenSearchService::Domain"),
    AWS_KINESIS_STREAM("AWS::Kinesis::Stream"),
    AWS_KINESIS_STREAM_CONSUMER("AWS::Kinesis::StreamConsumer"),
    AWS_KMS_KEY("AWS::KMS::Key"),
    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),
    AWS_S3_BUCKET("AWS::S3::Bucket"),
    AWS_S3_ACCESS_POINT("AWS::S3::AccessPoint"),
    AWS_S3_EXPRESS_DIRECTORY_BUCKET("AWS::S3Express::DirectoryBucket"),
    AWS_S3_GLACIER("AWS::S3::Glacier"),
    AWS_S3_OUTPOSTS_BUCKET("AWS::S3Outposts::Bucket"),
    AWS_S3_OUTPOSTS_ACCESS_POINT("AWS::S3Outposts::AccessPoint"),
    AWS_SECRETS_MANAGER_SECRET("AWS::SecretsManager::Secret"),
    AWS_SNS_TOPIC("AWS::SNS::Topic"),
    AWS_SQS_QUEUE("AWS::SQS::Queue"),
    AWS_IAM_ASSUME_ROLE_POLICY_DOCUMENT("AWS::IAM::AssumeRolePolicyDocument"),
    AWS_S3_TABLES_TABLE_BUCKET("AWS::S3Tables::TableBucket"),
    AWS_API_GATEWAY_REST_API("AWS::ApiGateway::RestApi"),
    AWS_CODE_ARTIFACT_DOMAIN("AWS::CodeArtifact::Domain"),
    AWS_BACKUP_BACKUP_VAULT("AWS::Backup::BackupVault"),
    AWS_CLOUD_TRAIL_DASHBOARD("AWS::CloudTrail::Dashboard"),
    AWS_CLOUD_TRAIL_EVENT_DATA_STORE("AWS::CloudTrail::EventDataStore"),
    AWS_S3_TABLES_TABLE("AWS::S3Tables::Table"),
    AWS_S3_EXPRESS_ACCESS_POINT("AWS::S3Express::AccessPoint"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessCheckResourceType> VALUE_MAP;
    private final String value;

    private AccessCheckResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessCheckResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessCheckResourceType> knownValues() {
        EnumSet<AccessCheckResourceType> knownValues = EnumSet.allOf(AccessCheckResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessCheckResourceType.class, AccessCheckResourceType::toString);
    }
}

