/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.EbsGroupListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.EbsUserIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsSnapshotConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsSnapshotConfiguration> {
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userIds").getter(EbsSnapshotConfiguration.getter(EbsSnapshotConfiguration::userIds)).setter(EbsSnapshotConfiguration.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groups").getter(EbsSnapshotConfiguration.getter(EbsSnapshotConfiguration::groups)).setter(EbsSnapshotConfiguration.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(EbsSnapshotConfiguration.getter(EbsSnapshotConfiguration::kmsKeyId)).setter(EbsSnapshotConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDS_FIELD, GROUPS_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("userIds", USER_IDS_FIELD);
            this.put("groups", GROUPS_FIELD);
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> userIds;
    private final List<String> groups;
    private final String kmsKeyId;

    private EbsSnapshotConfiguration(BuilderImpl builder) {
        this.userIds = builder.userIds;
        this.groups = builder.groups;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsSnapshotConfiguration)) {
            return false;
        }
        EbsSnapshotConfiguration other = (EbsSnapshotConfiguration)obj;
        return this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"EbsSnapshotConfiguration").add("UserIds", this.hasUserIds() ? this.userIds() : null).add("Groups", this.hasGroups() ? this.groups() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EbsSnapshotConfiguration, T> g) {
        return obj -> g.apply((EbsSnapshotConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsSnapshotConfiguration model) {
            this.userIds(model.userIds);
            this.groups(model.groups);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = EbsUserIdListCopier.copy(userIds);
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = EbsUserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = EbsGroupListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = EbsGroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public EbsSnapshotConfiguration build() {
            return new EbsSnapshotConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsSnapshotConfiguration> {
        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder kmsKeyId(String var1);
    }
}

