/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClientBuilder;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerServiceClientConfiguration;
import software.amazon.awssdk.services.accessanalyzer.DefaultAccessAnalyzerBaseClientBuilder;
import software.amazon.awssdk.services.accessanalyzer.DefaultAccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.endpoints.AccessAnalyzerEndpointProvider;

@SdkInternalApi
final class DefaultAccessAnalyzerClientBuilder
extends DefaultAccessAnalyzerBaseClientBuilder<AccessAnalyzerClientBuilder, AccessAnalyzerClient>
implements AccessAnalyzerClientBuilder {
    DefaultAccessAnalyzerClientBuilder() {
    }

    @Override
    public DefaultAccessAnalyzerClientBuilder endpointProvider(AccessAnalyzerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AccessAnalyzerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAccessAnalyzerClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AccessAnalyzerServiceClientConfiguration serviceClientConfiguration = AccessAnalyzerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAccessAnalyzerClient(serviceClientConfiguration, clientConfiguration);
    }
}

