/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClientBuilder;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerServiceClientConfiguration;
import software.amazon.awssdk.services.accessanalyzer.DefaultAccessAnalyzerBaseClientBuilder;
import software.amazon.awssdk.services.accessanalyzer.DefaultAccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.endpoints.AccessAnalyzerEndpointProvider;

@SdkInternalApi
final class DefaultAccessAnalyzerClientBuilder
extends DefaultAccessAnalyzerBaseClientBuilder<AccessAnalyzerClientBuilder, AccessAnalyzerClient>
implements AccessAnalyzerClientBuilder {
    DefaultAccessAnalyzerClientBuilder() {
    }

    @Override
    public DefaultAccessAnalyzerClientBuilder endpointProvider(AccessAnalyzerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AccessAnalyzerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAccessAnalyzerClientBuilder.validateClientOptions(clientConfiguration);
        AccessAnalyzerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAccessAnalyzerClient client = new DefaultAccessAnalyzerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AccessAnalyzerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AccessAnalyzerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

