/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3AccessPointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3AccessPointConfiguration> {
    private static final SdkField<String> ACCESS_POINT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPointPolicy").getter(S3AccessPointConfiguration.getter(S3AccessPointConfiguration::accessPointPolicy)).setter(S3AccessPointConfiguration.setter(Builder::accessPointPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointPolicy").build()}).build();
    private static final SdkField<NetworkOriginConfiguration> NETWORK_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkOrigin").getter(S3AccessPointConfiguration.getter(S3AccessPointConfiguration::networkOrigin)).setter(S3AccessPointConfiguration.setter(Builder::networkOrigin)).constructor(NetworkOriginConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOrigin").build()}).build();
    private static final SdkField<S3PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("publicAccessBlock").getter(S3AccessPointConfiguration.getter(S3AccessPointConfiguration::publicAccessBlock)).setter(S3AccessPointConfiguration.setter(Builder::publicAccessBlock)).constructor(S3PublicAccessBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccessBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_POLICY_FIELD, NETWORK_ORIGIN_FIELD, PUBLIC_ACCESS_BLOCK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessPointPolicy;
    private final NetworkOriginConfiguration networkOrigin;
    private final S3PublicAccessBlockConfiguration publicAccessBlock;

    private S3AccessPointConfiguration(BuilderImpl builder) {
        this.accessPointPolicy = builder.accessPointPolicy;
        this.networkOrigin = builder.networkOrigin;
        this.publicAccessBlock = builder.publicAccessBlock;
    }

    public final String accessPointPolicy() {
        return this.accessPointPolicy;
    }

    public final NetworkOriginConfiguration networkOrigin() {
        return this.networkOrigin;
    }

    public final S3PublicAccessBlockConfiguration publicAccessBlock() {
        return this.publicAccessBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPointConfiguration)) {
            return false;
        }
        S3AccessPointConfiguration other = (S3AccessPointConfiguration)obj;
        return Objects.equals(this.accessPointPolicy(), other.accessPointPolicy()) && Objects.equals(this.networkOrigin(), other.networkOrigin()) && Objects.equals(this.publicAccessBlock(), other.publicAccessBlock());
    }

    public final String toString() {
        return ToString.builder((String)"S3AccessPointConfiguration").add("AccessPointPolicy", (Object)this.accessPointPolicy()).add("NetworkOrigin", (Object)this.networkOrigin()).add("PublicAccessBlock", (Object)this.publicAccessBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPointPolicy": {
                return Optional.ofNullable(clazz.cast(this.accessPointPolicy()));
            }
            case "networkOrigin": {
                return Optional.ofNullable(clazz.cast(this.networkOrigin()));
            }
            case "publicAccessBlock": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3AccessPointConfiguration, T> g) {
        return obj -> g.apply((S3AccessPointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPointPolicy;
        private NetworkOriginConfiguration networkOrigin;
        private S3PublicAccessBlockConfiguration publicAccessBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessPointConfiguration model) {
            this.accessPointPolicy(model.accessPointPolicy);
            this.networkOrigin(model.networkOrigin);
            this.publicAccessBlock(model.publicAccessBlock);
        }

        public final String getAccessPointPolicy() {
            return this.accessPointPolicy;
        }

        public final void setAccessPointPolicy(String accessPointPolicy) {
            this.accessPointPolicy = accessPointPolicy;
        }

        @Override
        public final Builder accessPointPolicy(String accessPointPolicy) {
            this.accessPointPolicy = accessPointPolicy;
            return this;
        }

        public final NetworkOriginConfiguration.Builder getNetworkOrigin() {
            return this.networkOrigin != null ? this.networkOrigin.toBuilder() : null;
        }

        public final void setNetworkOrigin(NetworkOriginConfiguration.BuilderImpl networkOrigin) {
            this.networkOrigin = networkOrigin != null ? networkOrigin.build() : null;
        }

        @Override
        public final Builder networkOrigin(NetworkOriginConfiguration networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        public final S3PublicAccessBlockConfiguration.Builder getPublicAccessBlock() {
            return this.publicAccessBlock != null ? this.publicAccessBlock.toBuilder() : null;
        }

        public final void setPublicAccessBlock(S3PublicAccessBlockConfiguration.BuilderImpl publicAccessBlock) {
            this.publicAccessBlock = publicAccessBlock != null ? publicAccessBlock.build() : null;
        }

        @Override
        public final Builder publicAccessBlock(S3PublicAccessBlockConfiguration publicAccessBlock) {
            this.publicAccessBlock = publicAccessBlock;
            return this;
        }

        public S3AccessPointConfiguration build() {
            return new S3AccessPointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3AccessPointConfiguration> {
        public Builder accessPointPolicy(String var1);

        public Builder networkOrigin(NetworkOriginConfiguration var1);

        default public Builder networkOrigin(Consumer<NetworkOriginConfiguration.Builder> networkOrigin) {
            return this.networkOrigin((NetworkOriginConfiguration)((NetworkOriginConfiguration.Builder)NetworkOriginConfiguration.builder().applyMutation(networkOrigin)).build());
        }

        public Builder publicAccessBlock(S3PublicAccessBlockConfiguration var1);

        default public Builder publicAccessBlock(Consumer<S3PublicAccessBlockConfiguration.Builder> publicAccessBlock) {
            return this.publicAccessBlock((S3PublicAccessBlockConfiguration)((S3PublicAccessBlockConfiguration.Builder)S3PublicAccessBlockConfiguration.builder().applyMutation(publicAccessBlock)).build());
        }
    }
}

