/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.Configuration;
import software.amazon.awssdk.services.accessanalyzer.model.ConfigurationsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessPreviewRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, CreateAccessPreviewRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerArn").getter(CreateAccessPreviewRequest.getter(CreateAccessPreviewRequest::analyzerArn)).setter(CreateAccessPreviewRequest.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAccessPreviewRequest.getter(CreateAccessPreviewRequest::clientToken)).setter(CreateAccessPreviewRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configurations").getter(CreateAccessPreviewRequest.getter(CreateAccessPreviewRequest::configurations)).setter(CreateAccessPreviewRequest.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATIONS_FIELD));
    private final String analyzerArn;
    private final String clientToken;
    private final Map<String, Configuration> configurations;

    private CreateAccessPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.clientToken = builder.clientToken;
        this.configurations = builder.configurations;
    }

    public final String analyzerArn() {
        return this.analyzerArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, Configuration> configurations() {
        return this.configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPreviewRequest)) {
            return false;
        }
        CreateAccessPreviewRequest other = (CreateAccessPreviewRequest)((Object)obj);
        return Objects.equals(this.analyzerArn(), other.analyzerArn()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessPreviewRequest").add("AnalyzerArn", (Object)this.analyzerArn()).add("ClientToken", (Object)this.clientToken()).add("Configurations", this.hasConfigurations() ? this.configurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPreviewRequest, T> g) {
        return obj -> g.apply((CreateAccessPreviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerArn;
        private String clientToken;
        private Map<String, Configuration> configurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPreviewRequest model) {
            super(model);
            this.analyzerArn(model.analyzerArn);
            this.clientToken(model.clientToken);
            this.configurations(model.configurations);
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, Configuration.Builder> getConfigurations() {
            Map<String, Configuration.Builder> result = ConfigurationsMapCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Map<String, Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationsMapCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Map<String, Configuration> configurations) {
            this.configurations = ConfigurationsMapCopier.copy(configurations);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessPreviewRequest build() {
            return new CreateAccessPreviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessPreviewRequest> {
        public Builder analyzerArn(String var1);

        public Builder clientToken(String var1);

        public Builder configurations(Map<String, Configuration> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

