/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Position
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Position> {
    private static final SdkField<Integer> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("column").getter(Position.getter(Position::column)).setter(Position.setter(Builder::column)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("column").build()}).build();
    private static final SdkField<Integer> LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("line").getter(Position.getter(Position::line)).setter(Position.setter(Builder::line)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("line").build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("offset").getter(Position.getter(Position::offset)).setter(Position.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, LINE_FIELD, OFFSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer column;
    private final Integer line;
    private final Integer offset;

    private Position(BuilderImpl builder) {
        this.column = builder.column;
        this.line = builder.line;
        this.offset = builder.offset;
    }

    public final Integer column() {
        return this.column;
    }

    public final Integer line() {
        return this.line;
    }

    public final Integer offset() {
        return this.offset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.line());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.line(), other.line()) && Objects.equals(this.offset(), other.offset());
    }

    public final String toString() {
        return ToString.builder((String)"Position").add("Column", (Object)this.column()).add("Line", (Object)this.line()).add("Offset", (Object)this.offset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "line": {
                return Optional.ofNullable(clazz.cast(this.line()));
            }
            case "offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Position, T> g) {
        return obj -> g.apply((Position)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer column;
        private Integer line;
        private Integer offset;

        private BuilderImpl() {
        }

        private BuilderImpl(Position model) {
            this.column(model.column);
            this.line(model.line);
            this.offset(model.offset);
        }

        public final Integer getColumn() {
            return this.column;
        }

        public final void setColumn(Integer column) {
            this.column = column;
        }

        @Override
        public final Builder column(Integer column) {
            this.column = column;
            return this;
        }

        public final Integer getLine() {
            return this.line;
        }

        public final void setLine(Integer line) {
            this.line = line;
        }

        @Override
        public final Builder line(Integer line) {
            this.line = line;
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Position build() {
            return new Position(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Position> {
        public Builder column(Integer var1);

        public Builder line(Integer var1);

        public Builder offset(Integer var1);
    }
}

