/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Configuration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Configuration> {
    private static final SdkField<IamRoleConfiguration> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamRole").getter(Configuration.getter(Configuration::iamRole)).setter(Configuration.setter(Builder::iamRole)).constructor(IamRoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<KmsKeyConfiguration> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kmsKey").getter(Configuration.getter(Configuration::kmsKey)).setter(Configuration.setter(Builder::kmsKey)).constructor(KmsKeyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final SdkField<S3BucketConfiguration> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Bucket").getter(Configuration.getter(Configuration::s3Bucket)).setter(Configuration.setter(Builder::s3Bucket)).constructor(S3BucketConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<SecretsManagerSecretConfiguration> SECRETS_MANAGER_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("secretsManagerSecret").getter(Configuration.getter(Configuration::secretsManagerSecret)).setter(Configuration.setter(Builder::secretsManagerSecret)).constructor(SecretsManagerSecretConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManagerSecret").build()}).build();
    private static final SdkField<SqsQueueConfiguration> SQS_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqsQueue").getter(Configuration.getter(Configuration::sqsQueue)).setter(Configuration.setter(Builder::sqsQueue)).constructor(SqsQueueConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqsQueue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_FIELD, KMS_KEY_FIELD, S3_BUCKET_FIELD, SECRETS_MANAGER_SECRET_FIELD, SQS_QUEUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final IamRoleConfiguration iamRole;
    private final KmsKeyConfiguration kmsKey;
    private final S3BucketConfiguration s3Bucket;
    private final SecretsManagerSecretConfiguration secretsManagerSecret;
    private final SqsQueueConfiguration sqsQueue;
    private final Type type;

    private Configuration(BuilderImpl builder) {
        this.iamRole = builder.iamRole;
        this.kmsKey = builder.kmsKey;
        this.s3Bucket = builder.s3Bucket;
        this.secretsManagerSecret = builder.secretsManagerSecret;
        this.sqsQueue = builder.sqsQueue;
        this.type = builder.type;
    }

    public final IamRoleConfiguration iamRole() {
        return this.iamRole;
    }

    public final KmsKeyConfiguration kmsKey() {
        return this.kmsKey;
    }

    public final S3BucketConfiguration s3Bucket() {
        return this.s3Bucket;
    }

    public final SecretsManagerSecretConfiguration secretsManagerSecret() {
        return this.secretsManagerSecret;
    }

    public final SqsQueueConfiguration sqsQueue() {
        return this.sqsQueue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.secretsManagerSecret(), other.secretsManagerSecret()) && Objects.equals(this.sqsQueue(), other.sqsQueue());
    }

    public final String toString() {
        return ToString.builder((String)"Configuration").add("IamRole", (Object)this.iamRole()).add("KmsKey", (Object)this.kmsKey()).add("S3Bucket", (Object)this.s3Bucket()).add("SecretsManagerSecret", (Object)this.secretsManagerSecret()).add("SqsQueue", (Object)this.sqsQueue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "secretsManagerSecret": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecret()));
            }
            case "sqsQueue": {
                return Optional.ofNullable(clazz.cast(this.sqsQueue()));
            }
        }
        return Optional.empty();
    }

    public static Configuration fromIamRole(IamRoleConfiguration iamRole) {
        return (Configuration)Configuration.builder().iamRole(iamRole).build();
    }

    public static Configuration fromIamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
        IamRoleConfiguration.Builder builder = IamRoleConfiguration.builder();
        iamRole.accept(builder);
        return Configuration.fromIamRole((IamRoleConfiguration)builder.build());
    }

    public static Configuration fromKmsKey(KmsKeyConfiguration kmsKey) {
        return (Configuration)Configuration.builder().kmsKey(kmsKey).build();
    }

    public static Configuration fromKmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
        KmsKeyConfiguration.Builder builder = KmsKeyConfiguration.builder();
        kmsKey.accept(builder);
        return Configuration.fromKmsKey((KmsKeyConfiguration)builder.build());
    }

    public static Configuration fromS3Bucket(S3BucketConfiguration s3Bucket) {
        return (Configuration)Configuration.builder().s3Bucket(s3Bucket).build();
    }

    public static Configuration fromS3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
        S3BucketConfiguration.Builder builder = S3BucketConfiguration.builder();
        s3Bucket.accept(builder);
        return Configuration.fromS3Bucket((S3BucketConfiguration)builder.build());
    }

    public static Configuration fromSecretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
        return (Configuration)Configuration.builder().secretsManagerSecret(secretsManagerSecret).build();
    }

    public static Configuration fromSecretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
        SecretsManagerSecretConfiguration.Builder builder = SecretsManagerSecretConfiguration.builder();
        secretsManagerSecret.accept(builder);
        return Configuration.fromSecretsManagerSecret((SecretsManagerSecretConfiguration)builder.build());
    }

    public static Configuration fromSqsQueue(SqsQueueConfiguration sqsQueue) {
        return (Configuration)Configuration.builder().sqsQueue(sqsQueue).build();
    }

    public static Configuration fromSqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
        SqsQueueConfiguration.Builder builder = SqsQueueConfiguration.builder();
        sqsQueue.accept(builder);
        return Configuration.fromSqsQueue((SqsQueueConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IAM_ROLE,
        KMS_KEY,
        S3_BUCKET,
        SECRETS_MANAGER_SECRET,
        SQS_QUEUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IamRoleConfiguration iamRole;
        private KmsKeyConfiguration kmsKey;
        private S3BucketConfiguration s3Bucket;
        private SecretsManagerSecretConfiguration secretsManagerSecret;
        private SqsQueueConfiguration sqsQueue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            this.iamRole(model.iamRole);
            this.kmsKey(model.kmsKey);
            this.s3Bucket(model.s3Bucket);
            this.secretsManagerSecret(model.secretsManagerSecret);
            this.sqsQueue(model.sqsQueue);
        }

        public final IamRoleConfiguration.Builder getIamRole() {
            return this.iamRole != null ? this.iamRole.toBuilder() : null;
        }

        public final void setIamRole(IamRoleConfiguration.BuilderImpl iamRole) {
            IamRoleConfiguration oldValue = this.iamRole;
            this.iamRole = iamRole != null ? iamRole.build() : null;
            this.handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
        }

        @Override
        @Transient
        public final Builder iamRole(IamRoleConfiguration iamRole) {
            IamRoleConfiguration oldValue = this.iamRole;
            this.iamRole = iamRole;
            this.handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
            return this;
        }

        public final KmsKeyConfiguration.Builder getKmsKey() {
            return this.kmsKey != null ? this.kmsKey.toBuilder() : null;
        }

        public final void setKmsKey(KmsKeyConfiguration.BuilderImpl kmsKey) {
            KmsKeyConfiguration oldValue = this.kmsKey;
            this.kmsKey = kmsKey != null ? kmsKey.build() : null;
            this.handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
        }

        @Override
        @Transient
        public final Builder kmsKey(KmsKeyConfiguration kmsKey) {
            KmsKeyConfiguration oldValue = this.kmsKey;
            this.kmsKey = kmsKey;
            this.handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
            return this;
        }

        public final S3BucketConfiguration.Builder getS3Bucket() {
            return this.s3Bucket != null ? this.s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3BucketConfiguration.BuilderImpl s3Bucket) {
            S3BucketConfiguration oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
            this.handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
        }

        @Override
        @Transient
        public final Builder s3Bucket(S3BucketConfiguration s3Bucket) {
            S3BucketConfiguration oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket;
            this.handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
            return this;
        }

        public final SecretsManagerSecretConfiguration.Builder getSecretsManagerSecret() {
            return this.secretsManagerSecret != null ? this.secretsManagerSecret.toBuilder() : null;
        }

        public final void setSecretsManagerSecret(SecretsManagerSecretConfiguration.BuilderImpl secretsManagerSecret) {
            SecretsManagerSecretConfiguration oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret != null ? secretsManagerSecret.build() : null;
            this.handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
        }

        @Override
        @Transient
        public final Builder secretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
            SecretsManagerSecretConfiguration oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret;
            this.handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
            return this;
        }

        public final SqsQueueConfiguration.Builder getSqsQueue() {
            return this.sqsQueue != null ? this.sqsQueue.toBuilder() : null;
        }

        public final void setSqsQueue(SqsQueueConfiguration.BuilderImpl sqsQueue) {
            SqsQueueConfiguration oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue != null ? sqsQueue.build() : null;
            this.handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
        }

        @Override
        @Transient
        public final Builder sqsQueue(SqsQueueConfiguration sqsQueue) {
            SqsQueueConfiguration oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue;
            this.handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Configuration> {
        public Builder iamRole(IamRoleConfiguration var1);

        default public Builder iamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
            return this.iamRole((IamRoleConfiguration)((IamRoleConfiguration.Builder)IamRoleConfiguration.builder().applyMutation(iamRole)).build());
        }

        public Builder kmsKey(KmsKeyConfiguration var1);

        default public Builder kmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
            return this.kmsKey((KmsKeyConfiguration)((KmsKeyConfiguration.Builder)KmsKeyConfiguration.builder().applyMutation(kmsKey)).build());
        }

        public Builder s3Bucket(S3BucketConfiguration var1);

        default public Builder s3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
            return this.s3Bucket((S3BucketConfiguration)((S3BucketConfiguration.Builder)S3BucketConfiguration.builder().applyMutation(s3Bucket)).build());
        }

        public Builder secretsManagerSecret(SecretsManagerSecretConfiguration var1);

        default public Builder secretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
            return this.secretsManagerSecret((SecretsManagerSecretConfiguration)((SecretsManagerSecretConfiguration.Builder)SecretsManagerSecretConfiguration.builder().applyMutation(secretsManagerSecret)).build());
        }

        public Builder sqsQueue(SqsQueueConfiguration var1);

        default public Builder sqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
            return this.sqsQueue((SqsQueueConfiguration)((SqsQueueConfiguration.Builder)SqsQueueConfiguration.builder().applyMutation(sqsQueue)).build());
        }
    }
}

