/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ArchiveRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListArchiveRulesResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, ListArchiveRulesResponse> {
    private static final SdkField<List<ArchiveRuleSummary>> ARCHIVE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("archiveRules").getter(ListArchiveRulesResponse.getter(ListArchiveRulesResponse::archiveRules)).setter(ListArchiveRulesResponse.setter(Builder::archiveRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArchiveRuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListArchiveRulesResponse.getter(ListArchiveRulesResponse::nextToken)).setter(ListArchiveRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_RULES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ArchiveRuleSummary> archiveRules;
    private final String nextToken;

    private ListArchiveRulesResponse(BuilderImpl builder) {
        super(builder);
        this.archiveRules = builder.archiveRules;
        this.nextToken = builder.nextToken;
    }

    public boolean hasArchiveRules() {
        return this.archiveRules != null && !(this.archiveRules instanceof SdkAutoConstructList);
    }

    public List<ArchiveRuleSummary> archiveRules() {
        return this.archiveRules;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchiveRules() ? this.archiveRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveRulesResponse)) {
            return false;
        }
        ListArchiveRulesResponse other = (ListArchiveRulesResponse)((Object)obj);
        return this.hasArchiveRules() == other.hasArchiveRules() && Objects.equals(this.archiveRules(), other.archiveRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListArchiveRulesResponse").add("ArchiveRules", this.hasArchiveRules() ? this.archiveRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "archiveRules": {
                return Optional.ofNullable(clazz.cast(this.archiveRules()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveRulesResponse, T> g) {
        return obj -> g.apply((ListArchiveRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private List<ArchiveRuleSummary> archiveRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveRulesResponse model) {
            super(model);
            this.archiveRules(model.archiveRules);
            this.nextToken(model.nextToken);
        }

        public final Collection<ArchiveRuleSummary.Builder> getArchiveRules() {
            if (this.archiveRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.archiveRules != null ? (Collection)this.archiveRules.stream().map(ArchiveRuleSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder archiveRules(Collection<ArchiveRuleSummary> archiveRules) {
            this.archiveRules = ArchiveRulesListCopier.copy(archiveRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(ArchiveRuleSummary ... archiveRules) {
            this.archiveRules(Arrays.asList(archiveRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(Consumer<ArchiveRuleSummary.Builder> ... archiveRules) {
            this.archiveRules(Stream.of(archiveRules).map(c -> (ArchiveRuleSummary)((ArchiveRuleSummary.Builder)ArchiveRuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArchiveRules(Collection<ArchiveRuleSummary.BuilderImpl> archiveRules) {
            this.archiveRules = ArchiveRulesListCopier.copyFromBuilder(archiveRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListArchiveRulesResponse build() {
            return new ListArchiveRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListArchiveRulesResponse> {
        public Builder archiveRules(Collection<ArchiveRuleSummary> var1);

        public Builder archiveRules(ArchiveRuleSummary ... var1);

        public Builder archiveRules(Consumer<ArchiveRuleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

