/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ActionListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ConditionKeyMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatus;
import software.amazon.awssdk.services.accessanalyzer.model.PrincipalMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Finding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Finding> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Finding.getter(Finding::action)).setter(Finding.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Finding.getter(Finding::analyzedAt)).setter(Finding.setter(Builder::analyzedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Finding.getter(Finding::condition)).setter(Finding.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Finding.getter(Finding::createdAt)).setter(Finding.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::error)).setter(Finding.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::id)).setter(Finding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Finding.getter(Finding::isPublic)).setter(Finding.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Finding.getter(Finding::principal)).setter(Finding.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::resource)).setter(Finding.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::resourceOwnerAccount)).setter(Finding.setter(Builder::resourceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::resourceTypeAsString)).setter(Finding.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::statusAsString)).setter(Finding.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Finding.getter(Finding::updatedAt)).setter(Finding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ANALYZED_AT_FIELD, CONDITION_FIELD, CREATED_AT_FIELD, ERROR_FIELD, ID_FIELD, IS_PUBLIC_FIELD, PRINCIPAL_FIELD, RESOURCE_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> action;
    private final Instant analyzedAt;
    private final Map<String, String> condition;
    private final Instant createdAt;
    private final String error;
    private final String id;
    private final Boolean isPublic;
    private final Map<String, String> principal;
    private final String resource;
    private final String resourceOwnerAccount;
    private final String resourceType;
    private final String status;
    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.action = builder.action;
        this.analyzedAt = builder.analyzedAt;
        this.condition = builder.condition;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.id = builder.id;
        this.isPublic = builder.isPublic;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public List<String> action() {
        return this.action;
    }

    public Instant analyzedAt() {
        return this.analyzedAt;
    }

    public boolean hasCondition() {
        return this.condition != null && !(this.condition instanceof SdkAutoConstructMap);
    }

    public Map<String, String> condition() {
        return this.condition;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String error() {
        return this.error;
    }

    public String id() {
        return this.id;
    }

    public Boolean isPublic() {
        return this.isPublic;
    }

    public boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructMap);
    }

    public Map<String, String> principal() {
        return this.principal;
    }

    public String resource() {
        return this.resource;
    }

    public String resourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.analyzedAt(), other.analyzedAt()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isPublic(), other.isPublic()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.resourceOwnerAccount(), other.resourceOwnerAccount()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"Finding").add("Action", this.action()).add("AnalyzedAt", (Object)this.analyzedAt()).add("Condition", this.condition()).add("CreatedAt", (Object)this.createdAt()).add("Error", (Object)this.error()).add("Id", (Object)this.id()).add("IsPublic", (Object)this.isPublic()).add("Principal", this.principal()).add("Resource", (Object)this.resource()).add("ResourceOwnerAccount", (Object)this.resourceOwnerAccount()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "analyzedAt": {
                return Optional.ofNullable(clazz.cast(this.analyzedAt()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "resourceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAccount()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private Instant analyzedAt;
        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private String error;
        private String id;
        private Boolean isPublic;
        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();
        private String resource;
        private String resourceOwnerAccount;
        private String resourceType;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.action(model.action);
            this.analyzedAt(model.analyzedAt);
            this.condition(model.condition);
            this.createdAt(model.createdAt);
            this.error(model.error);
            this.id(model.id);
            this.isPublic(model.isPublic);
            this.principal(model.principal);
            this.resource(model.resource);
            this.resourceOwnerAccount(model.resourceOwnerAccount);
            this.resourceType(model.resourceType);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final Collection<String> getAction() {
            return this.action;
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        public final Instant getAnalyzedAt() {
            return this.analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        public final Map<String, String> getCondition() {
            return this.condition;
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        public final Map<String, String> getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getResourceOwnerAccount() {
            return this.resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Finding build() {
            return new Finding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Finding> {
        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder analyzedAt(Instant var1);

        public Builder condition(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder error(String var1);

        public Builder id(String var1);

        public Builder isPublic(Boolean var1);

        public Builder principal(Map<String, String> var1);

        public Builder resource(String var1);

        public Builder resourceOwnerAccount(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

