/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse;

public class ListAnalyzersPublisher
implements SdkPublisher<ListAnalyzersResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ListAnalyzersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnalyzersPublisher(AccessAnalyzerAsyncClient client, ListAnalyzersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnalyzersPublisher(AccessAnalyzerAsyncClient client, ListAnalyzersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnalyzersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnalyzersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAnalyzersResponseFetcher
    implements AsyncPageFetcher<ListAnalyzersResponse> {
        private ListAnalyzersResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalyzersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnalyzersResponse> nextPage(ListAnalyzersResponse previousPage) {
            if (previousPage == null) {
                return ListAnalyzersPublisher.this.client.listAnalyzers(ListAnalyzersPublisher.this.firstRequest);
            }
            return ListAnalyzersPublisher.this.client.listAnalyzers((ListAnalyzersRequest)((Object)ListAnalyzersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

